module EasyToDoListModule
  class Hooks < Redmine::Hook::ViewListener

    def view_layouts_base_body_bottom(context={})
      return if !User.current.logged? || context[:controller].is_mobile_device?

      format = context[:controller].params[:format]
      if format.nil? || format == 'html'
        context[:controller].send(:render_to_string, partial: 'easy_to_do_lists/view_layouts_base_body_bottom', locals: context)
      end
    end

    def easy_extensions_javascripts_hook(context={})
      context[:template].require_asset('easy_to_do_list_application')
    end

  end
end
