module EasyProjectCom
  module EasyPatch
    module EasyTenantServicePatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :set_account_information, :easy_project_com

        end
      end

      module InstanceMethods

        def set_account_information_with_easy_project_com
          set_account_information_without_easy_project_com
          Apartment::Tenant.switch(@easy_tenant.database_name) do
            @user.update_columns(must_change_passwd: true, easy_show_invitation: true)
          end
        end
      end

    end
  end
end
EasyExtensions::PatchManager.register_other_patch 'EasyHostingServices::EasyTenantService', 'EasyProjectCom::EasyPatch::EasyTenantServicePatch', if: proc { Redmine::Plugin.installed?(:easy_hosting_services) }
