module EasyProjectCom
  module EasyPatch
    module UserPatch

     def self.included(base)

       base.class_eval do

         safe_attributes 'inline_manual_is_complete'

         class << self

           def owner
             (User.current.internal_name == 'owner' && User.current) || User.active.find_by(internal_name: 'owner') || (User.current.admin? && User.current) || User.active.find_by(admin: true)
           end

           def search_results(token, _user, _project, options={})
             User.visible.like(token).limit(options[:limit])
           end

         end

         def inline_manual_is_complete=(boolean)
           pref[:inline_manual_is_complete] = !!boolean
         end

         def inline_manual_is_complete
           !!pref[:inline_manual_is_complete]# || (created_on < 30.days.ago)
         end

       end
     end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'User', 'EasyProjectCom::EasyPatch::UserPatch'
