module EasyProjectCom
  module EasyPatch
    module UsersControllerPatch

      def self.included(base)

        base.class_eval do

          before_action :render_limit_reached, only: [:new, :create, :unarchive, :bulk_unarchive], if: ->{!EasyLicenseManager.has_license_limit?(:active_user_limit)}

          def render_limit_reached
            return render(template: 'easy_trial_expiration/limit_reached', status: 402)
            false
          end

        end
      end

    end
  end
end
EasyExtensions::PatchManager.register_controller_patch 'UsersController', 'EasyProjectCom::EasyPatch::UsersControllerPatch'
