class EasyTimeEntriesController < BulkTimeEntriesController

  # before_action :find_entity, if: proc { params[:project_id].present? }

  def new
    get_time_entry
    respond_to do |format|
      format.js
      format.html { redirect_to bulk_time_entries_path(project_id: @project, back_url: params[:back_url]) }
    end
  end

  def save
    if @time_entry.issue && @time_entry.project != @time_entry.issue.project
      @time_entry.project = @time_entry.issue.project
    end

    if @time_entry.project && @time_entry.project.fixed_activity? && @time_entry.activity_id.blank?
      @time_entry.activity_id = @time_entry.issue.activity_id if @time_entry.issue
    end

    respond_to do |format|
      if @time_entry.save
        format.js
        format.html {redirect_to home_path}
      else
        format.js
        format.html {render action: 'index'}
      end
    end
  end

  private

  def authorize_global
    super('bulk_time_entries', params[:action], true)
  end

  # private
  #
  # def find_entity
  #   if params[:project_id]
  #     find_project_by_project_id
  #   elsif params[:issue_id]
  #     @issue = Issue.find(params[:issue_id])
  #     @project = @issue.id
  #   end
  # rescue ActiveRecord::RecordNotFound
  #   render_404
  # end
end

