class EasyProjectAttachmentQuery < EasyQuery

  def entity_easy_query_path(options)
    polymorphic_path([self.project, :easy_project_attachments], options)
  end

  def self.permission_view_entities
    :view_easy_project_attachments
  end

  def query_after_initialize
    super
    self.easy_query_entity_controller = 'easy_project_attachments'
    self.require_is_tagged            = true
  end

  def additional_statement
    unless @additional_statement_added
      @additional_statement = project_statement unless project_statement.blank?
      @additional_statement_added = true
    end
    @additional_statement
  end

  def available_filters
    return @available_filters unless @available_filters.blank?

    group = l("label_filter_group_#{self.class.name.underscore}")
    @available_filters = {
      'container_type' => { :type => :list, :order => 1, :values => [[l(:label_issue), 'Issue'], [l(:label_document), 'Document']], :name => l(:label_easy_project_attachments_container_type), :group => group },
      'filename' => { :type => :text, :order => 2, :group => group },
      'filesize' => { :type => :integer, :order => 3, :group => group },
      'downloads' => { :type => :integer, :order => 4, :group => group },
      'created_on' => { :type => :date_period, :order => 5, :group => group }
    }
    add_custom_fields_filters(AttachmentCustomField)

    @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      group_user = l('label_user_plural')
      @available_columns = [
        EasyQueryColumn.new(:container_type, :sortable => "#{Attachment.table_name}.container_type", :groupable => true, :caption => :label_easy_project_attachments_container_type, :group => group),
        EasyQueryColumn.new(:container_link, :caption => :label_easy_project_attachments_container_link, :group => group),
        EasyQueryColumn.new(:filename, :sortable => "#{Attachment.table_name}.filename", :groupable => true, :group => group),
        EasyQueryColumn.new(:filesize, :sortable => "#{Attachment.table_name}.filesize", :group => group),
        EasyQueryColumn.new(:downloads, :sortable => "#{Attachment.table_name}.downloads", :group => group),
        EasyQueryColumn.new(:author, :sortable => lambda{User.fields_for_order_statement}, :group => group_user),
        EasyQueryColumn.new(:description, :group => group),
        EasyQueryColumn.new(:created_on, :sortable => "#{Attachment.table_name}.created_on", :default_order => 'desc', :group => group),
      ]
      @available_columns.concat(AttachmentCustomField.all.collect { |cf| EasyQueryCustomFieldColumn.new(cf) })

      @available_columns_added = true
    end
    @available_columns
  end

  def searchable_columns
    ["#{Attachment.table_name}.filename", "#{Attachment.table_name}.description"]
  end

  def entity
    Attachment
  end

  def self.chart_support?
    true
  end

  def default_find_include
    [:author]
  end

  protected

  def project_statement
    return nil unless self.project

    "CASE #{Attachment.table_name}.container_type
      WHEN 'Issue' THEN EXISTS(SELECT i.id FROM #{Issue.table_name} i WHERE i.id = #{Attachment.table_name}.container_id AND i.project_id = #{self.project.id})
      WHEN 'Document' THEN EXISTS(SELECT d.id FROM #{Document.table_name} d WHERE d.id = #{Attachment.table_name}.container_id AND d.project_id = #{self.project.id})
      WHEN 'News' THEN EXISTS(SELECT i.id FROM #{News.table_name} i WHERE i.id = #{Attachment.table_name}.container_id AND i.project_id = #{self.project.id})
    END"
  end

end
