module EasyPrintableTemplates
  module EasyQueryButtonsHelperPatch

    def self.included(base)
      base.class_eval do

        def easy_printable_template_query_additional_ending_buttons(entity, options = {})
          s = ''
          if options[:easy_printable_templates] && options[:easy_printable_templates][:show_print_button]
            link_hash = {:controller => 'easy_printable_templates', :action => 'preview', :id => entity.id, :entity_type => options[:easy_printable_templates][:entity_type], :entity_id => options[:easy_printable_templates][:entity_id], :back_url => options[:easy_printable_templates][:back_url], :entity_settings => options[:easy_printable_templates][:entity_settings], :project_id => options[:easy_printable_templates][:project_id], :selected_ids => options[:easy_printable_templates][:selected_ids]}
            s << link_to(l(:button_easy_printable_templates_preview_and_print), link_hash.delete_if{|k,v| v.blank? }, class: 'icon icon-watcher', title: l(:button_easy_printable_templates_preview_and_print), onclick: 'easyModel.print.preview(this); return false;')
          else
            s << link_to(l(:button_edit), edit_easy_printable_template_path(entity), :class => 'icon icon-edit', :title => l(:button_edit)) if entity.editable?
            s << link_to(l(:button_delete), easy_printable_template_path(entity), :method => :delete, :data => {:confirm => l(:text_are_you_sure)}, :class => 'icon icon-del', :title => l(:button_delete)) if entity.deletable?
          end
          s.html_safe
        end

      end
    end

  end
end

EasyExtensions::PatchManager.register_helper_patch 'EasyQueryButtonsHelper', 'EasyPrintableTemplates::EasyQueryButtonsHelperPatch'
