require File.expand_path('../../spec_helper', __FILE__)

describe EasyUserTimeCalendar, :logged => :admin do

  let(:user_calendar) { User.current.current_working_time_calendar }
  let(:exceptions) { FactoryGirl.create_list(:easy_user_time_calendar_exception, 4, calendar: user_calendar) }

  it 'returns exceptions in array' do
    #without cache
    sorted_arry = exceptions.sort{|e1, e2| e2.exception_date <=> e1.exception_date }
    expect( sorted_arry ).to match_array( user_calendar.exception_between(Date.today - 10.days, Date.today + 10.days) )
    #from cache
    expect( sorted_arry ).to match_array( user_calendar.exception_between(Date.today - 9.days, Date.today + 9.days) )
  end

end
