require File.expand_path('../../spec_helper', __FILE__)

describe I18n, :null => true do
  let( :numbers ) { Array.new(8, &Proc.new {|n| 5*(10**(n*3))}).unshift(0, 1) }

  describe 'number_to_human_size' do # 5 => "5 Bytes", 5000 => "5 kB"...

    I18n.available_locales.each do |locale|
      it "should generate number_to_human_size on locale #{locale}" do
        I18n.locale = locale
        numbers.each do |number|
          str = nil
          expect{
            str = number_to_human_size(number)
          }.not_to raise_error
          expect( str ).to be_present
          expect( str ).to be_a String
        end
      end
    end

  end

  describe 'number_to_human' do # 5000 => "5 Thousand"...

    I18n.available_locales.each do |locale|
      it "should generate number_to_human on locale #{locale}" do
        I18n.locale = locale
        numbers.each do |number|
          str = nil
          expect{
            str = number_to_human(number)
          }.not_to raise_error
          expect(str).to be_present
          expect(str).to be_a String
        end
      end
    end

  end

  it 'should not raise an exception with unknown locale' do
    expect{I18n.t(:field_author, :locale => :aa)}.not_to raise_error
  end

end
