require File.expand_path('../../spec_helper', __FILE__)

describe JournalsController, :logged => :admin do
  let!(:project) { FactoryGirl.create(:project, :members => [User.current]) }
  let!(:journal) { FactoryGirl.create(:journal) }

  it 'renders 406 header when HTML access to edit journal' do
    project.issues.first.journals << journal

    get :edit, :id => journal.id, :format => :html
    expect(response).to have_http_status(406)

    xhr :get, :edit, :id => journal.id
    expect(response).to be_success
  end
end
