require File.expand_path('../../spec_helper', __FILE__)

describe EasyPageTemplatesController do
  describe 'page templates', logged: :admin do
    render_views
    let(:template) { EasyPageTemplate.create(:easy_pages_id => 1, :template_name => 'TestTemplate', :description => 'TestTemplate', :is_default => true) }
    let(:template_module) { EasyPageTemplateModule.create(:easy_page_templates_id => template.id,
        :easy_page_available_zones_id => 1, :easy_page_available_modules_id => 13, :tab_id => nil, :settings => HashWithIndifferentAccess.new) }

    it 'show page template' do
      get :show_page_template, :id => template
    end

    it 'edit page template' do
      get :edit_page_template, :id => template
    end

    it 'show page template with module' do
      template_module
      get :show_page_template, :id => template
    end

    it 'edit page template with module' do
      template_module
      get :edit_page_template, :id => template
    end
  end

end