require File.expand_path('../../spec_helper', __FILE__)

describe EasyIssuesController, logged: :admin do

  let(:issue) {FactoryGirl.create(:issue)}

  describe 'form fields' do
    render_views

    it 'get' do
      get :form_fields, id: issue.id, project_id: issue.project.id, format: 'json'
      expect(response).to be_success

      get :form_fields, project_id: issue.project.id, format: 'json'
      expect(response).to be_success

      get :form_fields, id: Issue.last.id + 1, project_id: issue.project.id, format: 'json'
      expect(response).to have_http_status(404)

      issue.project.trackers = []
      get :form_fields, project_id: issue.project.id, format: 'json'
      expect(response).to have_http_status(500)
    end
  end

  describe 'issue tabs' do
    render_views

    let(:time_entry) { FactoryGirl.create(:time_entry, issue: issue) }

    it 'render spent_time' do
      time_entry
      get :render_tab, tab: 'spent_time', id: issue.id
      expect(response).to be_success
    end

    it 'render easy_entity_activity' do
      get :render_tab, tab: 'easy_entity_activity', id: issue.id
      expect(response).to be_success
    end
  end

end
