require File.expand_path('../../spec_helper', __FILE__)

describe AdminController, :logged => :admin do

  let!(:archived) { FactoryGirl.create(:project, status: Project::STATUS_ARCHIVED) }
  let!(:parent) { FactoryGirl.create(:project) }
  let!(:archived_child) { FactoryGirl.create(:project, parent: parent, status: Project::STATUS_ARCHIVED) }
  let!(:closed_child) { FactoryGirl.create(:project, parent: parent, status: Project::STATUS_CLOSED) }
  let!(:active_child) { FactoryGirl.create(:project, parent: parent) }

  context '#projects' do

    it 'should select active project by default' do
      get :projects
      expect( assigns(:projects).collect(&:id) ).to match_array([parent.id])
    end

    it 'return all projects if status is all' do
      get :projects, status: ''
      expect( assigns(:projects).collect(&:id) ).to match_array([parent.id, archived.id])
      expect( assigns(:with_visible_childs) ).to match_array([parent.id])
    end

    it 'return active subprojects with id' do
      xhr :get, :projects, root_id: parent.id
      expect( assigns(:projects).collect(&:id) ).to match_array([active_child.id])
    end

  end

  context 'info' do
    render_views

    it 'show environment' do
      get :info
      expect( response ).to be_success
    end
  end

end
