namespace :easyproject do
  namespace :scheduler do

    desc <<-END_DESC

    Example:
      bundle exec rake easyproject:scheduler:run_tasks RAILS_ENV=production
      bundle exec rake easyproject:scheduler:run_tasks force=true RAILS_ENV=production
    END_DESC
    task :run_tasks => :environment do

      force = !!ENV.delete('force')
      EasyRakeTask.execute_scheduled(force)

    end

    desc <<-END_DESC

    Example:
      bundle exec rake easyproject:scheduler:run_task id=5 RAILS_ENV=production
    END_DESC
    task :run_task => :environment do

      task = EasyRakeTask.find(ENV['id'])

      EasyRakeTask.execute_task task

    end

    task :run_threaded_tasks => :environment do

      force = !!ENV.delete('force')
      EasyRakeTask.execute_scheduled_in_threads(force)

    end

  end
end