module EasyPatch
  module AccessControlPermissionPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        attr_accessor :acts_as_admin, :acts_as_admin_proc, :easy_category

        alias_method_chain :initialize, :easy_extensions

        def add_actions(hash)
          hash.each do |controller, actions|
            if actions.is_a? Array
              @actions << actions.collect {|action| "#{controller}/#{action}"}
            else
              @actions << "#{controller}/#{actions}"
            end
          end
          @actions.flatten!
        end

        def permission_flags
          f = []
          f << 'r' if read?
          f << 'p' if public?
          f << 'm' if require_member?
          f << 'l' if require_loggedin?
          f
        end

        def acts_as_admin?(user=nil)
          if acts_as_admin_proc.is_a?(Proc)
            acts_as_admin_proc.call(user)
          else
            @acts_as_admin == true
          end
        end

        def set_options(options={})
          @public = !!options[:public] if options.key?(:public)
          @read = !!options[:read] if options.key?(:read)
          @require = options[:require] if options.key?(:require)
          @global = !!options[:global] if options.key?(:global)
        end

        def global?
          @global
        end

      end
    end

    module InstanceMethods

      def initialize_with_easy_extensions(name, hash, options)
        initialize_without_easy_extensions(name, hash, options)
        @global = !!options[:global]
        @easy_category = options[:easy_category] || options[:project_module]
      end

    end
  end
end
EasyExtensions::PatchManager.register_other_patch 'Redmine::AccessControl::Permission', 'EasyPatch::AccessControlPermissionPatch'
