module EasyPatch
  module TimeEntryActivityPatch

    def self.included(base)
      base.extend(ClassMethods)
      base.send(:include, InstanceMethods)

      base.class_eval do

        acts_as_easy_translate

        has_many :project_activity_roles, class_name: 'ProjectActivityRole', foreign_key: 'activity_id', dependent: :delete_all
        has_and_belongs_to_many :activity_roles_projects, join_table: 'projects_activity_roles', foreign_key: 'activity_id', class_name: 'Project'
        has_and_belongs_to_many :projects, join_table: 'projects_activities', foreign_key: 'activity_id'

        after_save :remove_from_projects_if_disabled
        after_destroy :delete_time_entry_activities

        def form_partial
          'enumerations/form_with_projects'
        end

        private

        def delete_time_entry_activities
          self.class.connection.execute("DELETE FROM #{ProjectActivity.table_name} WHERE activity_id = #{self.id}")
        end

        def remove_from_projects_if_disabled
          unless active?
            delete_time_entry_activities
          end
        end

      end
    end

    module InstanceMethods

    end

    module ClassMethods

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'TimeEntryActivity', 'EasyPatch::TimeEntryActivityPatch', after: 'Enumeration'
