module EasyPatch
  module EnumerationsControllerPatch

    def self.included(base)
      base.send(:include, InstanceMethods)

      base.class_eval do

        alias_method_chain :create, :easy_extensions
        alias_method_chain :update, :easy_extensions

        # redmine 3.4
        def enumeration_params
          params.permit(:enumeration => [:name, :active, :is_default, :position, :reorder_to_position])[:enumeration]
        end

      end
    end

    module InstanceMethods

      def create_with_easy_extensions
        @enumeration.attributes = enumeration_params
        if @enumeration.save
          call_hook(:controller_enumerations_create_after_save, {:enumeration => @enumeration})
          flash[:notice] = l(:notice_successful_create)
          redirect_back_or_default enumerations_path
        else
          render :action => 'new'
        end
      end

      def update_with_easy_extensions
        @enumeration.attributes = enumeration_params
        if @enumeration.save
          call_hook(:controller_enumerations_edit_after_save, {:enumeration => @enumeration})

          respond_to do |format|
            format.html {
              flash[:notice] = l(:notice_successful_update)
              redirect_back_or_default enumerations_path
            }
            format.js { render :nothing => true }
            format.api { render_api_ok }
          end
        else
          respond_to do |format|
            format.html { render :action => 'edit' }
            format.js { render :nothing => true, :status => 422 }
            format.api { render_validation_errors(@enumeration) }
          end
        end
      end

    end

  end

end
EasyExtensions::PatchManager.register_controller_patch 'EnumerationsController', 'EasyPatch::EnumerationsControllerPatch'
