require 'easy_extensions/easy_xml_data/importables/importable'
module EasyXmlData
  class IssueImportable < Importable
    
    def initialize(data)
      @klass = Issue
      super
    end
    
    def mappable?
      false
    end
    
    def update_attribute(record, name, value, map, xml)
      case name
      when 'project_id'
        record.project_id = map['project'][value]
      when 'parent_id'
        if value.present? && map['issue'] && map['issue'][value]
          record.parent_id = map['issue'][value]
        end
      else
        super
      end
    end

    def updatable_attribute?(attr_name)
      attr_name == 'parent_id' || super
    end

  end
end
