module EasyExtensions

  @@domain_name, @@version, @@additional_installer_rake_tasks = nil, nil, []

  mattr_writer :easy_quotes_engine

  mattr_accessor :debug_mode
  self.debug_mode = false

  # Skip rails middleware XmlParamsParser if path start with
  mattr_accessor :skip_middleware_xml_parser_for
  self.skip_middleware_xml_parser_for = ['/webdav', '/carddav', '/caldav']

  EASY_HELPERS_DIR = 'easy_helpers'
  EASY_PLUGINS_DIR = 'easy_plugins'
  RELATIVE_EASYPROJECT_PLUGIN_PATH = File.join('plugins', 'easyproject')
  RELATIVE_EASYPROJECT_EASY_PLUGINS_PATH = File.join(RELATIVE_EASYPROJECT_PLUGIN_PATH, EASY_PLUGINS_DIR)
  PATH_TO_EASYPROJECT_ROOT = File.join(Rails.root, RELATIVE_EASYPROJECT_PLUGIN_PATH)
  INSTALLATION_TASKS = /install|plugin:migrate|multitenants/.freeze

  EASYPROJECT_EASY_PLUGINS_DIR = File.join(Rails.root, RELATIVE_EASYPROJECT_EASY_PLUGINS_PATH)
  EASY_EXTENSIONS_DIR = File.join(EASYPROJECT_EASY_PLUGINS_DIR, 'easy_extensions')

  DEFAULT_PDF_LOGO_FILENAME = 'default_pdf_logo.png'

  SUPPORTED_LANGS = [:ar, :cs, :da, :de, :en, :'en-AU', :'en-GB', :'en-US', :es, :fi, :fr, :he, :hr, :hu, :it, :ja, :ko, :mk, :nl, :no, :pl, :'pt-BR', :pt, :ro, :th, :tr, :sk, :sl, :sq, :sr, :'sr-YU', :sv, :ru, :'zh-TW', :zh]

  REDMINE_CUSTOM_FIELDS = ['DocumentCategoryCustomField', 'GroupCustomField', 'IssueCustomField', 'IssuePriorityCustomField', 'ProjectCustomField',
    'TimeEntryActivityCustomField', 'TimeEntryCustomField', 'UserCustomField', 'VersionCustomField']

  CACHE_CSS_NAME        = 'easy_stylesheets'
  CACHE_JS_NAME         = 'easy_javascripts'
  REDMINE_CACHE_JS_NAME = 'redmine_cached_js'

  def self.domain_name
    Rails.cache.fetch('easy_extensions/domain_name') do
      begin
        [Setting.host_name, (Rails.root.to_s.split(/[\\\/]/) - ['public_html']).last].uniq.join('#')
      rescue
        'nodomain'
      end
    end
  end

  def self.easy_quotes_engine_instance
    @@easy_quotes_engine ||= EasyExtensions::EasyQuotes::EasyCustomQuotesEngine.new
  end

  def self.version
    unless @@version
      ep_site_version = nil
      version_path = File.join(Rails.root, 'version')
      File.open(version_path, 'r') do |f|
        begin
          ep_site_version = f.readline
        rescue
        end
      end if File.exists?(version_path)
      @@version = ep_site_version.to_s.strip
      @@version = 'not_detected' if @@version.blank?
    end
    @@version
  end

  def self.render_sidebar?(controller_name, action_name, params)
    val = EasyProjectSettings.disabled_sidebar[controller_name]
    if val.is_a?(Hash)
      if (val.has_key?(action_name))
        ca_val = val[action_name]
        if (ca_val.is_a?(String))
          return false
        elsif (ca_val.is_a?(Hash))
          ca_val.each do |k, v|
            unless (params[k].nil?)
              return false if params[k] == v
            end
          end
        end
      end
    elsif val.is_a?(Array)
      return false if val.include?(action_name)
    end if (val)

    return true
  end

  def self.easy_searchable_column_types
    @@easy_searchable_column_types ||= ['name', 'description', 'comment', 'other']
  end

  def self.register_additional_installer_tasks(task_name)
    @@additional_installer_rake_tasks ||= []
    @@additional_installer_rake_tasks << task_name unless @@additional_installer_rake_tasks.include?(task_name)
  end

  def self.additional_installer_rake_tasks
    @@additional_installer_rake_tasks || []
  end

  def self.puts(msg)
    STDOUT.puts(msg.to_s) if STDOUT && !Rails.env.test?
  end

  module EasyProjectSettings

    mattr_accessor :disabled_sidebar
    self.disabled_sidebar = {'calendars' => ['show'], 'users' => {'edit' => {'tab' => 'my_page'}}}

    mattr_accessor :disabled_features
    self.disabled_features = {
        :modules => ['boards', 'files', 'wiki', 'wiki_edits', 'messages', 'user_allocations', 'easy_other_permissions', 'easy_attendances', 'gantt'],
        :permissions => { 'boards' => :all, 'files' => :all, 'wiki' => :all, 'wiki_edits' => :all, 'messages' => :all, 'easy_attendances' => :all, 'gantt' => :all },
        :notifiables => ['wiki_content_added', 'wiki_content_updated', 'message_posted'],
        :search_types => ['wiki_pages', 'messages'],
        :suggester_search_types => ['changesets', 'messages', 'project'],
        :others => []
    }

    mattr_accessor :easy_color_schemes_count
    self.easy_color_schemes_count = 7

    mattr_accessor :easy_attendance_enabled
    self.easy_attendance_enabled = false

    mattr_accessor :app_name
    self.app_name = 'Easy Project'

    mattr_accessor :app_link
    self.app_link = 'www.easyproject.cz'

    mattr_accessor :app_email
    self.app_email = 'podpora@easyproject.cz'

    mattr_accessor :enable_copying_files_on_restart
    self.enable_copying_files_on_restart = true

    mattr_accessor :enable_copying_easy_images_to_public
    self.enable_copying_easy_images_to_public = true

    mattr_accessor :default_chart_colors
    self.default_chart_colors = ['#4bb2c5', '#eaa228', '#c5b47f', '#579575', '#839557', '#958c12', '#953579', '#4b5de4', '#d8b83f', '#ff5800', '#0085cc', '#c747a3', '#cddf54', '#fbd178', '#26b4e3', '#bd70c7']

    mattr_accessor :enable_easy_linux_friend
    self.enable_easy_linux_friend = false

    mattr_accessor :enable_easy_enhanced_repository
    self.enable_easy_enhanced_repository = false

    mattr_accessor :default_pdf_logo
    self.default_pdf_logo = File.join(EASY_EXTENSIONS_DIR, 'assets', 'images', DEFAULT_PDF_LOGO_FILENAME)

    mattr_accessor :default_pdf_logo_image
    self.default_pdf_logo_image = '/plugin_assets/easy_extensions/images/' << DEFAULT_PDF_LOGO_FILENAME

    mattr_accessor :iconset
    self.iconset = Pathname.new(EasyExtensions::EASY_EXTENSIONS_DIR).join('assets/stylesheets/scss/_variables_icons.scss')

  end

  # Hack for localizable menu attributes
  class MenuManagerProc < Proc
    def to_s
      self.call
    end
  end

end
