
EPExtensions = {
  setup: function() {
    $('.set_attachment_reminder').each(function(index) {
      EPExtensions.initReminder(this);
    });
    $('.checks_other_element').click(function() {
      EPExtensions.checkElement($('#' + $(this).data('checks')));
      $(this).focus();
    });
    //---- Authentication -----
    $('.selectable-authentication').click(function(e) {
      $('.selectable-authentication').removeClass('selected');
      var $form = $(this).closest('form');
      if ($form.length === 0)
        return;
      var name = $(this).closest('.authentications').data('name');
      var id = (name).replace(/\[/, '_').replace(/\]/, '');
      var $elem = $form.find('#' + id);
      var uid = $(this).find('.uid').data('uid');
      if ($elem.length > 0) {
        $elem.attr('value', uid);
      } else {
        $elem = $('<input></input>', {'type': 'hidden', 'id': id, 'name': name, 'value': uid});
        $form.prepend($elem);
      }
      $(this).addClass('selected');
    });
    EPExtensions.onReload();
  },
  // should be called after page element load
  onReload: function() {
    EASY.backgroundServices.loadAll();
  },
  initReminder: function(element) {
    var $form = $(element).parents('form'); //wish it is a single element, but if don't, should not be problem
    $form.submit(function() {
      var textareaId = $(element).attr('id');
      var isCK = $(element).data('ck');
      var value = EPExtensions.getDescriptionValue(textareaId, isCK);
      var confirm_message = $(element).data('reminder_confirm');
      var words = $(element).data('reminder_words');
      var regex = RegExp(words);
      if (value.match(regex)) {
        if (EPExtensions.hasFileAttached(this)) {
          return true;
        }
        if (!confirm(confirm_message)) {
          $form.removeAttr('data-submitted');
          return false;
        }
      }
    });
  },
  getDescriptionValue: function(elementId, isCK) {
    if (isCK) {
      var instance = CKEDITOR.instances[elementId];
      if (instance) {
        return instance.getData();
      } else {
        return '';
      }
    } else {
      return $('#' + elementId).val();
    }
  },
  hasFileAttached: function(formElement) {
    var hasFile = false;
    $(formElement).find('input[name*="attachments"]').filter(function() {
      return $(this).attr('name').match(/attachments\[\d+\]\[token\]/);
    }).each(function(index) {
      if ($(this).val() !== "") {
        hasFile = true;
        return true;
      }
    });
    $(formElement).find('input[type="file"],input[type="dropbox-minechooser"]').each(function(index) {
      if ($(this).val() !== "") {
        hasFile = true;
        return true;
      }
    });

    return hasFile;
  },
  checkElement: function(el) {
    $(el).prop("checked", true);
  },
  setAttrToUrl: function(url, name, value) {
    // value = encodeURIComponent(value);
    var attr_regex = RegExp(name + "=[^\&]+");
    if (url.match(attr_regex)) {
      return url.replace(attr_regex, name + '=' + value);
    }

    if (!url.match(/\?/)) {
      url += '?';
    } else if (!url.match(/\&$/)) {
      url += '&';
    }
    var paramHash = {};
    paramHash[name] = value;
    url += $.param(paramHash);
    return url;
  },
  issuesToggleRowGroup: function($element) {
    var tr = $element;
    var n = tr.next();
    tr.toggleClass('open').find('.expander').toggleClass('.icon-add').toggleClass('.icon-remove');
    while (n.length !== 0 && !n.hasClass('group')) {
      if (tr.hasClass('open'))
        n.show();
      else
        n.hide();
      n = n.next();
    }
  },
  showEasyModal: function(el, options) {
    var $el = $(el);
    var mh = ERUI.topMenu.outerHeight();
    var wh = window.innerHeight;
    var defaults = {
      width: '90%',
      modal: true,
      resizable: false,
      dialogClass: 'modal',
      maxHeight: wh - mh - 20,
      maxWidth: '100%',
      open: function( event, ui ) {
        ERUI.body.addClass('modal-opened');
        initEasyAutocomplete();
      },
      close: function( event, ui ) {
        ERUI.body.removeClass('modal-opened');
        $(this).dialog("destroy");
      }
    };
    $el.dialog( $.extend({}, defaults, options) );
  }
};
EASY.scheduledTasks.scheduledOnDocumentReady.push(EPExtensions.setup);
