(function () {
  var logging = true;

  /**
   * @param {String} key
   * @param {Function} func
   */
  function bindToWindow(key, func) {
    if (logging) {
      window[key] = function () {
        console.debug("window." + key + " called");
        func.apply(this, arguments);
      }
    } else {
      window[key] = func;
    }
  }

  bindToWindow("add_filter", EASY.query.addFilter);
  bindToWindow("toggle_filter", EASY.query.toggleFilter);
  bindToWindow("initEasyFilters", EASY.query.initEasyFilters);
  bindToWindow("toggleFilterButtons", EASY.query.toggleFilterButtons);
  bindToWindow("addOption", EASY.query.addOption);
  bindToWindow("removeOption", EASY.query.removeOption);
  bindToWindow("ToggleTableRowGroupVisibility", EASY.query.toggleTableRowGroupVisibility);
  bindToWindow("getEasyQueryFiltersForURL", EASY.query.getFiltersForURL);
  bindToWindow("applyEasyQueryFilters", EASY.query.applyFilters);
  bindToWindow("applyPreviewEasyQueryInModules", EASY.query.applyPreviewEasyQueryInModules);
  bindToWindow("getEasyQueryCustomFormattingForURL", EASY.query.getEasyQueryCustomFormattingForURL);
  bindToWindow("updateResourceAvailability", EASY.resources.updateAvailability);
  bindToWindow("ToggleMultiSelect", EASY.utils.toggleMultiSelect);
  bindToWindow("ToggleDiv", EASY.utils.toggleDiv);
  bindToWindow("ToggleDivAndChangeOpen", EASY.utils.toggleDivAndChangeOpen);
  bindToWindow("UpdateUserPref", EASY.utils.updateUserPref);
  bindToWindow("ToggleTableRowVisibility", EASY.utils.toggleTableRowVisibility);
  bindToWindow("HideTableRow", EASY.utils.hideTableRow);
  bindToWindow("ShowTableRow", EASY.utils.showTableRow);
  bindToWindow("toggleMyPageModule", EASY.utils.toggleMyPageModule);
  bindToWindow("openTogglingContainer", EASY.utils.openTogglingContainer);
  bindToWindow("submit_form", EASY.utils.submitForm);
  bindToWindow("toggle_operator", EASY.utils.toggleOperator);
  bindToWindow("easyUpdateCK", EASY.utils.updateCKE);
  bindToWindow("easyUpdateForm", EASY.utils.updateForm);
  bindToWindow("easyModalSubmitForm", EASY.utils.submitModalForm);
  bindToWindow("GoToURL", EASY.utils.goToUrl);
  bindToWindow("ShowAndScrollTo", EASY.utils.showAndScrollTo);
  bindToWindow("ShowAndScrollTo2", EASY.utils.showAndScrollTo);
  bindToWindow("displayTabsButtons2", EASY.utils.displayTabsButtons);
  bindToWindow("moveTabRight2", EASY.utils.moveTabRight);
  bindToWindow("switchElements", EASY.utils.switchElements);
  bindToWindow("toggleCheckbox", EASY.utils.toggleCheckbox);
  bindToWindow("toggleSidebar", EASY.utils.toggleSidebar);

// defrag 4

  bindToWindow("submitCfLongTextInlineEdit", EASY.customFields.submitCfLongTextInlineEdit);
  bindToWindow("initDragNDropHandlers", EASY.dragAndDrop.initHandlers);
  bindToWindow("initDragNDropReorders", EASY.dragAndDrop.initReorders);
  bindToWindow("collapseUnnecessaryJournals", EASY.journals.collapseUnnecessary);
  bindToWindow("toggleJournalDetails", EASY.journals.toggleDetails);
  bindToWindow("createModalSelectorWindow", EASY.modalSelector.showModal);
  bindToWindow("addContextMenuFor", EASY.contextMenu.addContextMenuFor);
  bindToWindow("reloadContextMenuInit", EASY.contextMenu.reloadInit);
  bindToWindow("moveMenuLeft", EASY.utils.moveMenuLeft);
  bindToWindow("moveMenuRight", EASY.utils.moveMenuRight);
  bindToWindow("backToTop", EASY.utils.backToTop);
  bindToWindow("contentHeightSwitchable", EASY.utils.contentHeightSwitchable);
  bindToWindow("setInfiniteScrollDefaults", EASY.utils.setInfiniteScrollDefaults);
  bindToWindow("setNameToModuleHead", EASY.utils.setNameToModuleHead);
  bindToWindow("initProjectEdit", EASY.utils.initProjectEdit);
  bindToWindow("initFileUploads", EASY.utils.initFileUploads);
  bindToWindow("showBroadcastFlashMessage", EASY.utils.broadcast.showBroadcastFlashMessage);
  bindToWindow("showPeriodDaysField", EASY.timeLog.showPeriodDaysField);
  bindToWindow("removeSelectedModalEntity", EASY.modalSelector.removeSelectedModalEntity);
  bindToWindow("changeModalSelectorValue", EASY.modalSelector.changeValue);
  bindToWindow("copySelectedModalEntities", EASY.modalSelector.copySelectedModalEntities);
  bindToWindow("closeModalSelectorWindow", EASY.modalSelector.closeModal);
  bindToWindow("showModalSelectorWindow", EASY.modalSelector.showEasyModal);
  bindToWindow("showFullscreen", EASY.modalSelector.showFullscreen);
  bindToWindow("saveAndCloseModalSelectorWindow", EASY.modalSelector.saveAndCloseModal);
  bindToWindow("bindInfiniteScrollModalSelector", EASY.modalSelector.bindInfiniteScroll);
  bindToWindow("unbindInfiniteScrollModalSelector", EASY.modalSelector.unbindInfiniteScroll);
  bindToWindow("selectAllOptions", EASY.modalSelector.selectAllOptions);
  bindToWindow("parseEasyQueryData", EASY.modalSelector.parseEasyQueryData);

})();

function oldMapping() {
  window.add_filter = EASY.query.addFilter;
  window.toggle_filter = EASY.query.toggleFilter;
  window.initEasyFilters = EASY.query.initEasyFilters;
  window.toggleFilterButtons = EASY.query.toggleFilterButtons;
  window.addOption = EASY.query.addOption;
  window.removeOption = EASY.query.removeOption;
  window.ToggleTableRowGroupVisibility = EASY.query.toggleTableRowGroupVisibility;
  window.getEasyQueryFiltersForURL = EASY.query.getFiltersForURL;
  window.applyEasyQueryFilters = EASY.query.applyFilters;
  window.applyPreviewEasyQueryInModules = EASY.query.applyPreviewEasyQueryInModules;
  window.getEasyQueryCustomFormattingForURL = EASY.query.getEasyQueryCustomFormattingForURL;
  window.updateResourceAvailability = EASY.resources.updateAvailability;
  window.ToggleMultiSelect = EASY.utils.toggleMultiSelect;
  window.ToggleDiv = EASY.utils.toggleDiv;
  window.ToggleDivAndChangeOpen = EASY.utils.toggleDivAndChangeOpen;
  window.UpdateUserPref = EASY.utils.updateUserPref;
  window.ToggleTableRowVisibility = EASY.utils.toggleTableRowVisibility;
  window.HideTableRow = EASY.utils.hideTableRow;
  window.ShowTableRow = EASY.utils.showTableRow;
  window.toggleMyPageModule = EASY.utils.toggleMyPageModule;
  window.openTogglingContainer = EASY.utils.openTogglingContainer;
  window.submit_form = EASY.utils.submitForm;
  window.toggle_operator = EASY.utils.toggleOperator;
  window.easyUpdateCK = EASY.utils.updateCKE;
  window.easyUpdateForm = EASY.utils.updateForm;
  window.easyModalSubmitForm = EASY.utils.submitModalForm;
  window.GoToURL = EASY.utils.goToUrl;
  window.ShowAndScrollTo = EASY.utils.showAndScrollTo;
  window.ShowAndScrollTo2 = EASY.utils.showAndScrollTo;
  window.displayTabsButtons2 = EASY.utils.displayTabsButtons;
  window.moveTabRight2 = EASY.utils.moveTabRight;
  window.switchElements = EASY.utils.switchElements;
  window.toggleCheckbox = EASY.utils.toggleCheckbox;
  window.toggleSidebar = EASY.utils.toggleSidebar;

  // defrag 4

  window.submitCfLongTextInlineEdit = EASY.customFields.submitCfLongTextInlineEdit;
  window.initDragNDropHandlers = EASY.dragAndDrop.initHandlers;
  window.initDragNDropReorders = EASY.dragAndDrop.initReorders;
  window.collapseUnnecessaryJournals = EASY.journals.collapseUnnecessary;
  window.toggleJournalDetails = EASY.journals.toggleDetails;
  window.createModalSelectorWindow = EASY.modalSelector.showModal;
  window.addContextMenuFor = EASY.contextMenu.addContextMenuFor;
  window.reloadContextMenuInit = EASY.contextMenu.reloadInit;
  window.moveMenuLeft = EASY.utils.moveMenuLeft;
  window.moveMenuRight = EASY.utils.moveMenuRight;
  window.backToTop = EASY.utils.backToTop;
  window.contentHeightSwitchable = EASY.utils.contentHeightSwitchable;
  window.setInfiniteScrollDefaults = EASY.utils.setInfiniteScrollDefaults;
  window.setNameToModuleHead = EASY.utils.setNameToModuleHead;
  window.initProjectEdit = EASY.utils.initProjectEdit;
  window.initFileUploads = EASY.utils.initFileUploads;
  window.showBroadcastFlashMessage = EASY.utils.broadcast.showBroadcastFlashMessage;
  window.showPeriodDaysField = EASY.timeLog.showPeriodDaysField;
  window.removeSelectedModalEntity = EASY.modalSelector.removeSelectedModalEntity;
  window.changeModalSelectorValue = EASY.modalSelector.changeValue;
  window.copySelectedModalEntities = EASY.modalSelector.copySelectedModalEntities;
  window.closeModalSelectorWindow = EASY.modalSelector.closeModal;
  window.showModalSelectorWindow = EASY.modalSelector.showEasyModal;
  window.showFullscreen = EASY.modalSelector.showFullscreen;
  window.saveAndCloseModalSelectorWindow = EASY.modalSelector.saveAndCloseModal;
  window.bindInfiniteScrollModalSelector = EASY.modalSelector.bindInfiniteScroll;
  window.unbindInfiniteScrollModalSelector = EASY.modalSelector.unbindInfiniteScroll;
  window.selectAllOptions = EASY.modalSelector.selectAllOptions;
  window.parseEasyQueryData = EASY.modalSelector.parseEasyQueryData;
}
