(function () {
    window.easyLoaders = window.easyLoaders || {};
    var scrums = {};

    /**
     * @param {String} targetSelector
     * @param {String} url
     */
    window.easyLoaders.scrum = function (targetSelector, url) {
        $.getJSON(url, function (data) {
            window.easyModel = window.easyModel || {};
            window.easyView = window.easyView || {};
            window.easyTemplates.ListItem = data["settings"]["template_card"];
            window.easyTemplates.issueCardWidget = data["settings"]["template_tooltip"];
            window.easyTemplates.kanbanColumnName = data["settings"]["template_column_name"];

            // common model
            var rootModel = easyClasses.root;

            var allMembersMap = rootModel.loadUsers(data["settings"]["project_members"]);
            var issues = new window.easyClasses.Issues();

            issues.loadFromJson(data["entities"], allMembersMap);

            var allIssuesMap = issues.map;

            // kanban model
            var clearColumns = [];
            for (var i = 0; i < data["columns"].length; i++) {
                if (data["columns"][i] != null) {
                    clearColumns.push(data["columns"][i]);
                }
            }

            var scrumRoot = new window.easyClasses.agile.ScrumRoot({
                columnsData: clearColumns,
                update_params_prefix: data.settings.update_params_prefix,
                assign_param_name: data.settings.assign_param_name,
                settings: data.settings,
                url: url,
                i18n: data.i18n,
                allIssuesMap: allIssuesMap,
                allMembersMap: allMembersMap,
                contextMenuUrl: data["settings"]["context_menu_path"],
                dragDomain: targetSelector,
                localStorageKey: easyConstants.agileSwimlanesGroupByParameter + targetSelector,
                reloadAgile: function () {
                    window.easyLoaders.scrum(targetSelector, url);
                }
            });

            // model
            // -----
            // view

            var scrum = scrums[targetSelector];
            if (scrum) {
                scrum.scrumRootWidget.destroy();
                scrum.scrumRoot.destroy();
            }

            var scrumRootWidget = new window.easyClasses.agile.ScrumRootWidget(scrumRoot, true);
            scrumRootWidget.$target = $(targetSelector);
            window.easyView.root.add(scrumRootWidget);

            scrums[targetSelector] = {
                scrumRootWidget: scrumRootWidget,
                scrumRoot: scrumRoot
            }

        });
    };

    window.easyLoaders.scrumDestroy = function (selector) {
        var scrum = scrums[selector];
        if (scrum) {
            scrum.scrumRootWidget.destroy();
            scrum.scrumRoot.destroy();
            delete scrums[selector];
        }
    };

    window.easyModel.scrums = scrums;

})();
