class EasyChartBaseline < ActiveRecord::Base
  belongs_to :page_module, class_name: 'EasyPageZoneModule'

  attr_protected :id

  serialize :data
  serialize :ticks, Array
  serialize :options

  scope :visible, ->(user=User.current) {
    at = EasyPageZoneModule.arel_table
    joins(:page_module).where( at[:user_id].eq(user.id).or( at[:user_id].eq(nil) ) )
  }

  def data=(data)
    if data.is_a?(Hash)
      data['json'] = data['json'].values if data['json'].is_a?(Hash)
      data['columns'] = data['columns'].values if data['columns'].is_a?(Hash)
      data['groups'] = data['groups'].values if data['groups'].is_a?(Hash)
    end
    super(data)
  end

end
