class EasyActivity

  INVISIBLE_EVENT_TYPES = ['changesets', 'time_entries', 'easy_attendances']

  ALL_SCOPE = 'all'
  SELECTED_ACTIVITY_SCOPE = 'selected_event_types'
  SELECTED_PROJECTS_SCOPE = 'selected_projects'

  def self.set_scope_for_options(scope, user=User.current, options={})
    scope ||= ALL_SCOPE
    case scope
    when ALL_SCOPE
      options[:selected_event_types] = all_visible_event_types(user) unless options[:custom_event_types]
      options[:selected_projects] = nil
    when SELECTED_PROJECTS_SCOPE
      options[:selected_event_types] = all_visible_event_types(user) unless options[:custom_event_types]
    when SELECTED_ACTIVITY_SCOPE
      options[:selected_projects] = nil
    end

    options
  end

  # selected_event_types = ["issues", "changesets", "news", "documents", "files"]
  def self.last_events_fetcher(user, project, scope=nil, options={})
    options = set_scope_for_options(scope, user, options) if scope

    activity_options = {
      :project => project,
      :with_subprojects => options[:with_subprojects],
      :author => nil,
      :project_ids => options[:selected_projects],
      :user => options[:user],
      :display_updated => options[:display_updated]
    }
    activity = Redmine::Activity::Fetcher.new(user, activity_options)
    activity.scope = options[:selected_event_types]
    activity
  end

  def self.last_events_range(user)
    today = user.today
    if uwtc = user.current_working_time_calendar
      event_start_date = uwtc.shift_working_day(-1, today).beginning_of_day
    else
      event_start_date = today.beginning_of_day
    end
    [event_start_date, today.end_of_day]
  end

  def self.last_events(user, project, scope=nil, options={})
    activity = self.last_events_fetcher(user, project, scope, options)
    event_start_date, event_end_date = last_events_range(user)
    activity.easy_events(event_start_date, event_end_date, options)
  end

  def self.last_events_count(user, project, scope=nil, options={})
    activity = self.last_events_fetcher(user, project, scope, options)
    event_start_date, event_end_date = last_events_range(user)
    activity.easy_events_count(event_start_date, event_end_date, options)
  end

  def self.last_current_user_events_with_defaults
    options = {
               :with_subprojects => false,
               :user => User.current,
               :display_updated => true
              }

    EasyActivity.last_events(User.current, nil, ALL_SCOPE, options)
  end

  def self.last_current_user_events_with_defaults_count
    options = {
               :with_subprojects => false,
               :user => User.current,
               :display_updated => true
              }

    EasyActivity.last_events_count(User.current, nil, ALL_SCOPE, options)
  end

  def self.all_event_types(user)
    Redmine::Activity::Fetcher.new(user || User.current).event_types
  end

  def self.all_visible_event_types(user)
    all_event_types(user) - INVISIBLE_EVENT_TYPES
  end

end
