module EasyActivitiesHelper

  def format_activity_feed_description(text)
    content_tag(:i, truncate_html(strip_tags(text.to_s), 120))
  end

  def event_update_datetime(event)
    event.try(:updated_on) || event.try(:updated_at) || event.event_datetime
  end

  def event_last_journal(event)
    if event.respond_to?(:journals) && (journal = event.journals.with_notes.last) && (journal.notes.present?)
      return journal
    end
    nil
  end

end
