module Admin
  class EasyAdminController < ApplicationController
    accept_api_auth :version

    def version
      @version = Rails.root.join('version').read
      respond_to do |format|
        format.html {render text: @version}
        format.xml {render text: (x = Builder::XmlMarkup.new({});x.instruct!;x.version(@version))}
        format.json {render json: @version}
      end
    end

    private

    def require_login
      false # no login required. Override Redmine setting
    end
  end
end
