lib_dir = File.join(File.dirname(__FILE__), 'lib', 'easy_calendar')
# Dir[File.dirname(__FILE__) + '/test/mailers/previews/*.rb'].each {|file| require_dependency file } if Rails.env.development?

# Require patches
patch_path = File.join(lib_dir, '{redmine,easy_extensions}', '**', '*.rb')
Dir.glob(patch_path).each do |file|
  require_dependency file
end

EpmEasyCalendar.register_to_scope(:user, :plugin => :easy_calendar)
EpmEasyCalendar.register_to_page('easy-calendar-module', :plugin => :easy_calendar)
EpmProjectMeetings.register_to_scope(:project, :plugin => :easy_calendar)

EasyExtensions::PatchManager.register_easy_page_controller 'EasyCalendarController'

EasyExtensions::AfterInstallScripts.add do
  page = EasyPage.where(:page_name => 'easy-calendar-module').first
  page_template = page.default_template

  unless page_template
    page_template = EasyPageTemplate.create(:easy_pages_id => page.id, :template_name => 'Default template', :description => 'Default template', :is_default => true)

    EasyPageTemplateModule.create_template_module(page, page_template, EpmEasyCalendar.first, 'top-middle', HashWithIndifferentAccess.new(:enabled_calendars => ['easy_meeting_calendar'], :display_from => '09:00', :display_to => '20:00', :user_ids => [], :default_view => 'agendaWeek'), 1)
  end

  EasyPageZoneModule.create_from_page_template(page_template) if !page.all_modules.exists?
end

ActiveSupport.on_load(:easyproject, yield: true) do

  require 'easy_calendar/hooks'
  require 'easy_calendar/menus'
  require 'easy_calendar/proposer'
  require 'easy_calendar/internals'
  require 'easy_calendar/permissions'
  require 'easy_calendar/big_recurring_job'

end

Dir[File.dirname(__FILE__) + '/lib/easy_calendar/advanced_calendars/*.rb'].each {|file| require_dependency file}
Dir[File.dirname(__FILE__) + '/lib/easy_calendar/easy_attendances/*.rb'].each {|file| require_dependency file} if Redmine::Plugin.installed?(:easy_attendances)

ActionDispatch::Reloader.to_prepare do

  EasySetting.map.boolean_keys(:easy_caldav_enabled)

  EasyExtensions::EntityRepeater.map do |repeater|
    repeater.register 'EasyMeeting'
  end

end
