require File.expand_path('../../../../../easy_extensions/test/spec/spec_helper', __FILE__)

describe EasyQueriesController, :logged => :admin do

  describe 'EasyAgileBoard query' do
    let!(:query) { FactoryGirl.create(:easy_agile_board_query)}
    let(:backlog_url_hash) { {:controller => :easy_agile_board, :action => :backlog, :id => 1, :sprint_id => 1} }

    context 'is redirected after destroy' do
      it 'with back_url to backlog' do
        delete :destroy, id: query.id, back_url: easy_agile_board_backlog_url(backlog_url_hash)
        expect(response).to redirect_to(backlog_url_hash)
      end

      it 'without back_url to agile board' do
        delete :destroy, id: query.id
        expect(response).to redirect_to(:controller => :easy_agile_board, :action => :show, :id => query.project_id)
      end
    end
  end

end
