# DEV Guide - Common errors

1. [Development types](./README.md#code-checking-&-requirements)
   1. [Client modifications](./1_CLIENT_MODIFICATIONS.md)
   2. [Separate existing plugin](./2_SEPARATE_EXISTING_PLUGIN.md)
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. [Core implementations](./4_CORE_IMPLEMENTATIONS.md)
2. [Development](#development)
3. [Code style](./CODE_STYLE.md)
4. **Common errors**
5. [Repositories](./REPOSITORIES.md)
6. [Testing](./TESTS.md)

##### Rails find

- Volání `.find` vyhazuje vyjímky, které je nutné ošetřit. Následujíci kód má vždy potencionál vždy vyhodit chybu 500.

```ruby
Issue.find(params[:id])
```

- Alternativou je použití `.find_by` nebo zachycení vyjímek. V prvním případě je nutné ošetřit nil.

```ruby
begin
  Issue.find(params[:id])
rescue ActiveRecord::RecordNotFound
  render_404
rescue

@issue = Issue.find_by(id: params[:id])
@issue.project if @issue
```

##### Volání na nil

Je nejčastější problém. Vždy musíte počítat s možností, že proměná je nil.

```ruby
# On Hash
hash[:key1]
hash[:key1][:key2]

# On Array
[].flatten!.map(&:to_i)

# On model
@issue.assigned_to.name
```

##### Reloading v after_save

Ve všech callbacich by se neměla používat metoda `.reload`, protože vyresetuje atributy z [Active Model Dirty](http://api.rubyonrails.org/classes/ActiveModel/Dirty.html).
