# DEV Guide - Client modifications

1. [Development types](./README.md#code-checking-&-requirements)
   1. **Client modifications**
   2. [Separate existing plugin](./2_SEPARATE_EXISTING_PLUGIN.md)
   3. [Separate new plugin](./3_SEPARATE_NEW_PLUGIN.md)
   4. [Core implementations](./4_CORE_IMPLEMENTATIONS.md)
2. [Development](#development)
3. [Code style](./CODE_STYLE.md)
4. [Common errors](./COMMON_ERRORS.md)
5. [Repositories](./REPOSITORIES.md)
6. [Testing](./TESTS.md)

Úpravy určené konkrétnímu klientovi dle jeho požadavku. Většinou se jedná o jednorázovou a menší úpravu. Vývoj probíha pouze ve složce vygenerované generátorem (`plugins/easyproject/easy_plugins/modification_*`). Úpravy by měli co nejvíce využívát vlastní controllery/view a volání hooku.

Je důležité, aby veškerý vývoj probíhal pouze ve uvedené složce, protože při aktualizace je vše ostatní smazáne a nahrazene aktuálním kódem.

Patche do jádra jsou povolené jen ve výjmečnýh případech po předchozím schválením. Jsou na **plnou odpovědnost autora**.

Funkčnost kontroluje především klient. U těchto modifikacíh většinou nejsou žádné zásahy do jádra a tudiž probíhají minimální kontroly.

Plugin lze vygenerovat pomoci:

    rails generate redmine_extensions:plugin CLIENT_NAME --customer

Nápovědu lze získat:

    rails generate redmine_extensions:plugin --help
