class EasyToDoListItem < ActiveRecord::Base
  include Redmine::SafeAttributes

  default_scope{order("#{EasyToDoListItem.table_name}.position ASC")}

  belongs_to :easy_to_do_list
  belongs_to :entity, :polymorphic => true

  attr_protected :id

  acts_as_positioned :scope => :easy_to_do_list_id

  validates :name, :length => { :maximum => 255 }

  before_save :ensure_correct_list, :ensure_new_position

  attr_accessor :new_position, :new_list, :old_list

  safe_attributes 'name', 'entity_id', 'entity_type', 'new_position', 'is_done', 'new_list'

  private

  def ensure_new_position
    return if self.new_position.blank?
    new_new_position = self.new_position
    self.new_position = nil
    self.position = new_new_position.to_i
  end

  def ensure_correct_list
    return true if self.new_list.blank? || self.new_list.to_i == self.easy_to_do_list_id
    self.easy_to_do_list_id = self.new_list
    self.new_list = nil
    true
  end
end
