class EasyToDoListsController < ApplicationController

  before_action :find_easy_to_do_list, :only => [:update, :destroy]

  def show_toolbar
    if User.current.easy_to_do_lists.empty?
      User.current.easy_to_do_lists.create(name: l(:heading_easy_to_do_list))
    end

    @easy_to_do_lists = User.current.easy_to_do_lists.preload(:easy_to_do_list_items => :entity).all
    @new_easy_to_do_list = EasyToDoList.new if Setting.plugin_easy_to_do_list['enable_more_to_do_lists'] == '1'
    respond_to do |format|
      format.js
    end
  end

  def index
    respond_to do |format|
      format.json {render(json: User.current.easy_to_do_lists.preload(:easy_to_do_list_items), :include => :easy_to_do_list_items)}
    end
  end

  def show
    render :nothing => true
  end

  def new
    render :nothing => true
  end

  def create
    @easy_to_do_list = User.current.easy_to_do_lists.build
    @easy_to_do_list.safe_attributes = params[:easy_to_do_list] if params[:easy_to_do_list]
    @easy_to_do_list.new_position ||= 1

    if @easy_to_do_list.save
      respond_to do |format|
        format.js {render :partial => 'easy_to_do_lists/show', :formats => [:html], :locals => {:easy_to_do_list => @easy_to_do_list}}
      end
    else
      respond_to do |format|
        format.js {render :nothing => true}
      end
    end
  end

  def edit
    render :nothing => true
  end

  def update
    @easy_to_do_list.safe_attributes = params[:easy_to_do_list] if params[:easy_to_do_list]

    if @easy_to_do_list.save
      respond_to do |format|
        format.js {render :partial => 'easy_to_do_lists/show', :formats => [:html], :locals => {:easy_to_do_list => @easy_to_do_list}}
      end
    else
      respond_to do |format|
        format.js {render :nothing => true}
      end
    end
  end

  def destroy
    @easy_to_do_list.destroy

    respond_to do |format|
      format.js {render :nothing => true}
    end
  end

  private

  def find_easy_to_do_list
    @easy_to_do_list = User.current.easy_to_do_lists.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end

end
