module EasyProjectCom
  class Hooks < Redmine::Hook::ViewListener

    render_on :view_layout_top_tools, partial: 'easy_calendar/upcoming_events'
    render_on :view_account_login_bottom, partial: 'easy_project_com/login_buttons'

    def view_layouts_base_body_bottom(context = {})
      context[:hook_caller].send(:render, {partial: 'common/inline_manual'}) if Rails.env.production? && !User.current.inline_manual_is_complete
    end

    def view_layout_top_menu(context = {})
      html = ''
      html = context[:hook_caller].send(:render, {partial: 'layouts/invite_colleagues'}) if Redmine::Plugin.installed?(:easy_invite_colleagues)
      html << context[:hook_caller].send(:render, {partial: 'easy_imports/import_button'}) if (User.current.admin? && Redmine::Plugin.installed?(:easy_data_templates))
      return html unless User.current.logged?

      exceeded_limits = EasyLicenseManager.exceeded_limits
      if exceeded_limits.any?
        html << context[:hook_caller].send(:render, {partial: 'easy_trial_expiration/deactivate_entities/request'})
      elsif EasySetting.value(:first_login_after_upgrade) && User.current == User.owner
        html << context[:hook_caller].send(:render, {partial: 'easy_trial_expiration/activate_entities/request'})
      end

      html
    end

    def helper_journal_render_notes_add_links(context = {})
      context[:links].delete_if{|x| x[l(:button_create_issue_from_journal)]}
    end

  end
end
