require 'omniauth-oauth2'
module OmniAuth
  module Strategies
    class Sso < OmniAuth::Strategies::OAuth2

      option :client_options, {
        :site => 'https://sso.easyproject.com',
        :authorize_url => 'https://sso.easyproject.com/auth/sso/authorize',
        :token_url => 'https://sso.easyproject.com/auth/sso/token'
      }

      uid do
        raw_info['id']
      end

      info do
        {
          :email => raw_info['info']['email'],
          :first_name => raw_info['info']['first_name'],
          :last_name => raw_info['info']['last_name'],
          :image => raw_info['info']['image']
        }
      end

      def raw_info
        @raw_info ||= access_token.get("/auth/sso/user.json?oauth_token=#{access_token.token}").parsed
      end

      def authorize_params
        super.merge(auth_provider: request.params['auth_provider'])
      end

    end
  end
end
