module EasyProjectCom
  module EasyPatch
    module EasyLicenseManagerPatch

     def self.included(base)
       base.extend(ClassMethods)
       base.class_eval do

         class << self

           alias_method_chain :get_active_project_count, :easy_project_com

           def get_active_user_count
             get_internal_user_count + get_external_user_count
           end

           def active_project_limit_exceeded?
             active_project_limit = get_active_project_limit
             active_project_limit == 0 ? false : (get_active_project_count > active_project_limit)
           end

           def active_user_limit_exceeded?
             internal_limit = EasyLicenseManager.get_license_limit(:internal_user_limit)
             if internal_limit > 0
               active_user_count = get_active_user_count
               user_limit_exceeded = active_user_count > internal_limit
             end
             user_limit_exceeded
           end

           def validate_active_user_limit
             internal_limit = get_license_limit(:internal_user_limit)
             if internal_limit > 0
               user_count = get_active_user_count
               internal_limit > user_count
             else
               true
             end
           end

           def exceeded_limits
             r = {}
             r[:active_user_limit_exceeded] = true if active_user_limit_exceeded?
             r[:active_project_limit_exceeded] = true if active_project_limit_exceeded?
             r
           end

         end

       end
     end

     module ClassMethods

       # can be deleted when this method is fixed in master
       def get_active_project_count_with_easy_project_com
         Project.non_templates.where.not(status: Project::STATUS_ARCHIVED).count
       end

     end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'EasyLicenseManager', 'EasyProjectCom::EasyPatch::EasyLicenseManagerPatch'
