module EasyProjectCom
  module EasyPatch
    module MailerPatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :mail, :easy_project_com
          alias_method_chain :issue_add, :easy_project_com
          alias_method_chain :issue_edit, :easy_project_com
          alias_method_chain :get_mail_subject_for_issue_add, :easy_project_com
          alias_method_chain :get_mail_subject_for_issue_edit, :easy_project_com

        end
      end

      module InstanceMethods

        def mail_with_easy_project_com(headers={}, &block)
          unless self.class.name.in? %w(EasyCalendarMailer EasyMailCampaignMailer)
            content = File.binread(File.join(EasyExtensions::EASYPROJECT_EASY_PLUGINS_DIR, 'easy_project_com/assets/images/ep-logo.png'))
            attachments['ep-logo.png'] = { content: content, content_disposition: 'inline' }
          end
          # attachments['logo_base64.png'] = {
          #     mime_type: 'image/png',
          #     content: Base64.encode64(File.read(File.join(EasyExtensions::EASYPROJECT_EASY_PLUGINS_DIR, 'easy_project_com/assets/images/logo.png')))
          # }
          mail_without_easy_project_com(headers, &block)
        end

        def issue_add_with_easy_project_com(issue, issue_recipients = {}, type = :all, lang = nil)
          return if issue.project && (issue.project.easy_is_easy_template? || issue.project.status == Project::STATUS_PLANNED)
          set_language_if_valid(lang) if lang
          redmine_headers 'Project' => issue.project.identifier,
                          'Issue-Id' => issue.id,
                          'Issue-Author' => issue.author.login
          redmine_headers 'Issue-Assignee' => issue.assigned_to.login if issue.assigned_to
          message_id issue
          references issue

          @author = issue.author # redmine inner logic in "mail" function
          @issue = issue
          @issue_url = issue_url(issue)
          @users = issue_recipients[:to] + issue_recipients[:cc]
          @receiver = User.find_by_mail(issue_recipients[:to][0]) if issue_recipients[:to].count == 1
          @receiver ||= issue.assigned_to if type == :assigned_to
          issue_subject = get_mail_subject_for_issue_add(issue, type)

          mail :to => issue_recipients[:to],
               :cc => issue_recipients[:cc],
               :subject => issue_subject
        end

        def issue_edit_with_easy_project_com(journal, issue_recipients = {}, type = :all, lang = nil)
          issue = journal.journalized
          return if issue.project && (issue.project.easy_is_easy_template? || issue.project.status == Project::STATUS_PLANNED)
          set_language_if_valid(lang) if lang
          redmine_headers 'Project' => issue.project.identifier,
                          'Issue-Id' => issue.id,
                          'Issue-Author' => issue.author.login
          redmine_headers 'Issue-Assignee' => issue.assigned_to.login if issue.assigned_to
          message_id journal
          references issue

          @author = journal.user # redmine inner logic in "mail" function
          @issue = issue
          @journal = journal
          @issue_url = issue_url(issue, :anchor => "change-#{journal.id}")
          @users = issue_recipients[:to] + issue_recipients[:cc]
          @receiver = User.find_by_mail(issue_recipients[:to][0]) if issue_recipients[:to].count == 1
          @receiver ||= issue.assigned_to if type == :assigned_to

          issue_subject = get_mail_subject_for_issue_edit(issue, journal, type)

          mail :to => issue_recipients[:to],
               :cc => issue_recipients[:cc],
               :subject => issue_subject
        end

        def get_mail_subject_for_issue_add_with_easy_project_com(issue, type = :all)
          l((type == :assigned_to ? :'mail.subject.my_issue_add' : :'mail.subject.issue_add'),
            :issuesubject => (EasySetting.value('show_issue_id', issue.project) ? "##{issue.id} - #{issue.subject}" : issue.subject),
            :projectname => issue.project.name)
        end

        def get_mail_subject_for_issue_edit_with_easy_project_com(issue, _journal, type = :all)
          l((type == :assigned_to ? :'mail.subject.my_issue_edit' : :'mail.subject.issue_edit'),
            :issuesubject => (EasySetting.value('show_issue_id', issue.project) ? "##{issue.id} - #{issue.subject}" : issue.subject),
            :projectname => issue.project.name)
        end

      end

    end
  end
end
EasyExtensions::PatchManager.register_model_patch 'Mailer', 'EasyProjectCom::EasyPatch::MailerPatch'
