module EasyProjectCom
  module EasyPatch
    module EntityAttributeHelperPatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :format_html_entity_attribute, :easy_project_com

        end
      end

      module InstanceMethods

        def format_html_entity_attribute_with_easy_project_com(entity_class, attribute, unformatted_value, options={})
          format_html_entity_attribute_without_easy_project_com(entity_class, attribute, unformatted_value, options.merge({editable: false, not_editable: true}))
        end

      end

    end
  end
end
EasyExtensions::PatchManager.register_helper_patch 'EntityAttributeHelper', 'EasyProjectCom::EasyPatch::EntityAttributeHelperPatch'
