module EasyProjectCom
  module EasyPatch
    module EasyQueryButtonsHelperPatch

      def self.included(base)
        base.send(:include, InstanceMethods)
        base.class_eval do

          alias_method_chain :easy_change_status_link, :easy_project_com
          alias_method_chain :easy_project_template_query_additional_ending_buttons, :easy_project_com

        end
      end

      module InstanceMethods

        def easy_change_status_link_with_easy_project_com(user, options={})
          if (!EasyLicenseManager.has_license_limit?(:active_user_limit) && user.locked?)
            link_to l(:button_unlock), easy_trial_expiration_limit_reached_path, method: :get, remote: true, class: "icon icon-unlock #{options[:additional_classes]}"
          else
            easy_change_status_link_without_easy_project_com(user, options)
          end
        end

        def easy_project_template_query_additional_ending_buttons_with_easy_project_com(project, options = {})
          if options[:only_create_project_from_template_button]
            s = ''
            return s unless EasyLicenseManager.has_license_limit?(:active_project_limit)

            parent_id = params[:project] && params[:project][:parent_id]
            s << link_to(content_tag(:span, l(:button_create_project_from_template), :class => 'tooltip'), show_create_project_template_path(id: project, :'project[parent_id]' => parent_id, assign_entity_id: params[:assign_entity_id], assign_entity_type: params[:assign_entity_type]), class: 'icon icon-play', title: l(:title_button_template_create_project)) if Project.allowed_to_create_project_from_template?
            s.html_safe
          else
            easy_project_template_query_additional_ending_buttons_without_easy_project_com(project, options = {})
          end
        end
      end
    end
  end
end
EasyExtensions::PatchManager.register_helper_patch 'EasyQueryButtonsHelper', 'EasyProjectCom::EasyPatch::EasyQueryButtonsHelperPatch'
