//= require easy_extensions
//= require easy_project_instant_messages
//= require_self

var menuToggler = false;

// window.initInlineEditForContainer = function() {}
// window.initEasyInlineEdit = function() {}

// $(document).ready(initEasyAutocomplete);
window.ERUI = window.ERUI || {};
ERUI.Widget = ERUI.Widget || {};

$.extend(ERUI,{
    tests: {
        sticky: function() {
            var el = document.createElement('a'),
                mStyle = el.style;
            mStyle.cssText = "position:sticky;position:-webkit-sticky;position:-ms-sticky;";
            // var bodyNula = document.getElementById('main');
            // bodyNula.className += 'sticky-fallback';
            if (mStyle.position.indexOf('sticky') === -1){
                return false;
            }
            return true;
        }
    }
});

function toggleMenu() {
  ERUI.topMenu.toggleClass('collapsed');
  // ERUI.main.trigger($.Event('resize'));
  EASY.utils.updateUserPref('hide_menu', null, ERUI.topMenu.hasClass('collapsed'));
}

$.widget( "ERUI.Widget", {

    // Name is there for developers comfort especially in error reporting
    name:"Widget Root",

    // Parent widget is parent of this widget in widget hierarchy tree
    parentWidget: this,

    // Target is jQuery element representing HTMLElement in which widget should be painted
    $target: null,

    options: {
        // Widget lang is i18n or just map used in repaint
        widgetLang: null,
    },


    // List<Widget>
    children: null,
    // set to true every time, you need to repaint widget. If it is set to true, next repaint loop will repaint the widget.
    repaintRequested: true,
    // stop repainting during some special operation (<input> create in <td>)
    keepPaintedState: false,

    _customInit: function () {
        // placeholder - fill in the descendants
    },

    _create: function() {
        var self = this;
        self.children =  new Array;
        self._customInit();
    },

    _destroy: function () {
        this._customDestroy();
    },

    _customDestroy: function(){
        // placeholder - fill in the descendants
    },

    _toggleState: function(){
        var self = this;
        self.state = !self.state;
    }
});

$.widget("ERUI.clickObserver" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Close elements on click out",

    _customInit: function(){
        var self = this;
        self.element.click( function( event ){
            for (var i = 0; i <  self.children.length; i++){
                self.children[i].clickOutCallback( event );
            }
        })
    },

    addClickTarget: function(object){
        var self = this;
        self.children.push(object);
    },

    _customDestroy: function(){

    }

});

$.widget("ERUI.toggleable" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Click on click out",

    content: null,

    observer: null,

    state: null,



    _customInit: function(){
        var self = this;
        self.state = false;
        self.content = self.options.content;
        self.trigger = self.options.trigger;
        self.observer = self.options.observer;
        self.openCallback = self.options.openCallback;

        self.observer.addClickTarget(self);

        if(self.trigger) self.$triggerElement = self.element.find(self.trigger);
        if(self.content) self.$contentElement = self.element.find(self.content);

        self.element.addClass('w-toggleable');

        var element = self.trigger ? self.$triggerElement : $(self.element) ;

        element.click( function( event ){
           var event = event || window.event; // use the value of event if available or if not assume it's IE and use window.event
            if(!self.state){
                if(!$(event.target).is('a')) {
                    self.element.addClass('w-toggleable--active');
                    if(self.trigger) self.$triggerElement.addClass('w-toggleable__trigger--active');
                    if(self.content) self.$contentElement.addClass('w-toggleable__content--active');

                    self._toggleState();
                    if (self.openCallback) self.openCallback();
                    return false;
                    //event.stopPropagation();
                }
            }else{
                self._close();
            }
        });
    },

    clickOutCallback: function ( event ){
        var self = this;
        if( self.state ){
            var element = self.content ? $(self.element).find(self.content) : self.element;
            element.each(function(item){
                if( !$.contains( this, event.target ) && !$(event.target).hasClass('icon-del') ){ //TODO: too hacky !$(event.target).hasClass('icon-del')
                    self._close();
                }
            })
        }
    },

    _close: function(){
        var self = this;
        self._cleanup();
        self._toggleState();
    },

    _cleanup: function(){
        var self = this;
        self.element.removeClass('w-toggleable--active');
        if(self.trigger) self.$triggerElement.removeClass('w-toggleable__trigger--active');
        if(self.content) self.$contentElement.removeClass('w-toggleable__content--active');
    },

    _customDestroy: function(){
        var self = this;
        self._cleanup();
    }
});


$.widget("ERUI.fullScreenButton" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Fullscreen mode",

    content: null,

    state: null,

    _customInit: function() {
        var self = this;
        self.state = false;
        self.content = self.options.content;
        var $content = $(self.content);

        self.element.click( function(){
            if(!self.state){
                self.element.addClass('fullscreen__trigger_active');
                $content.addClass('fullscreen');
                self._toggleState();
            } else {
                self.element.removeClass('fullscreen__trigger_active');
                $content.removeClass('fullscreen');
                self._toggleState();
            }

        });
    }
});

$.widget("ERUI.servicebarUtils" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Utilises servicebar",

    _customInit: function(){
        var self = this;
        var links = self.element.find('ul a');
        links.each(function (){
            var $this = $(this);
            $this.append($this.attr('title'));
        })

    },

    _customDestroy: function(){

    }

});

$.widget("ERUI.customTooltip" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Custom tooltip",

    content: null,

    observer: null,

    state: null,

    _customInit: function(){
        var self = this;
        self.element.each( function() {
            var $this = $(this);
            $this.attr('data-title', $this.attr('title'));
            $this.removeAttr('title');
            $this.addClass('tooltip');
            $this.find('.tooltip').remove();
            $this.append('<small class="tooltip-content">' + $this.attr("data-title") + '</small>');
        });
    },

});

$.widget("ERUI.tabScrollButtons" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name:"Left and right tab scrolling buttons",

    _customInit: function(){
        var self = this;

        var lis = self.element.find('ul').children('li');
        var tabsWidth = 0;
        self.element.each(function() {
            lis.each(function(index, li) {
                if ($(li).is(":visible")) {
                    tabsWidth += $(li).outerWidth();
                }
            });
            if ((tabsWidth < self.element.width() - 120) && (lis.first().is(":visible"))) {
                self.element.prev('div.tabs-buttons, td.tabs-button').hide();
            } else {
                self.element.prev('div.tabs-buttons, td.tabs-button').show();
            }
        });

        var leftButton = self.element.prev('div.tabs-buttons, td.tabs-button').find('.tab-left');
        var rightButton = self.element.prev('div.tabs-buttons, td.tabs-button').find('.tab-right');
        var scroll = self.element.scrollLeft();

        leftButton.click( function(){
            requestFrame(function(){
                self.element.scrollLeft(scroll - 120);
            });
        });

        rightButton.click( function(){
            requestFrame(function(){
                self.element.scrollLeft(scroll + 120);
            });
        });

        $(self.element).perfectScrollbar({
            suppressScrollY: true,
            useBothWheelAxes: true,
            swipePropagation: false,
            useKeyboard: false
        });
    },

    _customDestroy: function(){

    }

});

$.widget("ERUI.styleChat" , $.ERUI.Widget, {
    // Name is there for developers comfort especially in error reporting
    name: "Change chat appearance according to EP style",

    _customInit: function () {
        var servicebarItems = $('#easy_servicebar').find('li > a');
        servicebarItems.attr('onclick', 'window.EasyInstantMessenger.closeChat()');
        var self = this;
        self.element.addClass('EP_easyim');
        $('#easy_instant_messages_body').perfectScrollbar({
            suppressScrollX: true,
            includePadding: true,
            wheelPropagation: false,
            swipePropagation: false
        }).css({overflowY: 'hidden'});
    }
});

$(document).ready(function(){
    ERUI.clickObserver = $('#wrapper').clickObserver().data("ERUI-clickObserver");
    $('#easy_page_tabs').tabScrollButtons();
    $('#easy_instant_messages_wrapper').styleChat();
    $('.menu-easy-new-entity__wrapper').toggleable({trigger: '.menu-easy-new-entity__trigger', content: '.menu-easy-new-entity', observer: ERUI.clickObserver});
    $('.main_menu__more, .main_menu__settings').toggleable({content: 'ul', observer: ERUI.clickObserver});
    $('.easy-calendar-upcoming__calendar').toggleable({trigger: '.easy-calendar-upcoming__calendar-trigger', content: '.easy-calendar-upcoming__calendar-content', observer: ERUI.clickObserver});
    $('#easy_servicebar').servicebarUtils();
    $('.fullscreen__trigger').fullScreenButton({content: '#content'});

    $('#wrapper').find('[title]').not('th').customTooltip();
    $('#easy_page_tabs').tabScrollButtons();
    $('#easy_instant_messages_wrapper').styleChat();


    //makes all labels vith checkboxes and radios to have title
    $('label.checkbox, label.radio').each( function(index, value){
        var $self = $(this);
        $self.attr('title', $self.text());
    })
});

window.affix = {
    register: new Array(),
    enabled: {
        tableScrollbars:    false,
        sidebar:            false,
        formActions :       false
    },
    prepareHeads: function($theads){
        $theads.each(function(){
            var maxHeight = 0;
            var css = new Array;
            var $this = $(this);
            var $parent = $this.parent();
            var $cells = $this.find('th,td');
            $cells.each(function (index){
                var $this = $(this);
                css[index] = new Array;
                css[index]['paddingTop'] = $this.css( "paddingTop" );
                css[index]['paddingRight'] = $this.css( "paddingRight" );
                css[index]['paddingBottom'] = $this.css( "paddingBottom" );
                css[index]['paddingLeft'] = $this.css( "paddingLeft" );

                var currentHeight = $this.height();
                if (currentHeight > maxHeight){
                    maxHeight = currentHeight;
                }
            });
            $this.detach();
            $cells.each(function (index){
                var $this = $(this);
                $this.append('<div class="affix-cell-wrap" style="padding:' + css[index]['paddingTop'] + ' ' + css[index]['paddingRight'] + ' ' + css[index]['paddingBottom'] + ' ' + css[index]['paddingLeft'] + '; z-index: 1; ">'+$this.html()+'</div>');
                $this.find('.affix-cell-wrap .editable-parent span.icon-edit').remove();
            });
            $parent.prepend( $this );
        });
        return $theads;
    },
    recalculateHeads:  function($theads){
        $theads.each(function(){
            var maxHeight = 0;
            var $this = $(this);
            var $cells = $this.find('th,td');
            $cells.each(function (index){
                var $this = $(this);
                var currentHeight = $this.height();
                if (currentHeight > maxHeight){
                    maxHeight = currentHeight;
                }
            });
            $cells.each(function (index){
                var $this = $(this);
                // $this.find('.affix-cell-wrap').css({'height':1 + maxHeight});
            });
        });
    },
    preInit: function(){
        affix.register['main'] = false;
        affix.register['document'] = false;
        affix.register['topMenu'] = false;
        affix.register['sidebar'] = false;
        affix.register['tableScrolls'] = false;
        affix.register['tableHeads'] = false;
        affix.register['formActions'] = false;
        affix.prepareHeads(ERUI.tableHeads);
        $( document ).on( "erui_interface_change_horizontal", function() {
            affix.recalculateHeads(ERUI.tableHeads);
        });
        if(!ERUI.tests.sticky()){
            ERUI.body.addClass('stickyFallback');
        }

        window.ERUI.formActions = $("body.stickyFallback .form-actions").not('.wiki .form-actions, #filter_buttons');
        affix.init(true);
    },
    reInit: function(){
        //if(affix.register['tableHeads']) {
        //    $.each(affix.register['tableHeads'].parent.element, function (index, element) {
        //        if(affix.register['tableHeads'].fake.element[index] === null)
        //            return;
        //        element.removeChild(affix.register['tableHeads'].fake.element[index]);
        //    });
        //}
        affix.init(false);
    },
    init: function(reset){
        window.ERUI.formActions = $("body.stickyFallback .form-actions").not('.wiki .form-actions, #filter_buttons');
        affix.register['window'] = { height: window.innerHeight };
        if (!$.fx.off && !ERUI.isMobile) {

            var main = false;
            if (ERUI.main && ERUI.main.length > 0) {
                main = {};
                main.element = ERUI.main;
                main.position = main.element[0].getBoundingClientRect();
                main.scroll = 0;
                affix.register['main'] = main;
            }

            var document = false;
            if (ERUI.html && ERUI.html.length > 0) {
              document = {};
              document.element = ERUI.html;
              document.position = document.element[0].getBoundingClientRect();
              document.scroll = 0;
              affix.register['document'] = document;
            }

            var topMenu = false;
            if (ERUI.topMenu && ERUI.topMenu.length > 0) {
                topMenu = {};
                topMenu.element = ERUI.topMenu;
                topMenu.position = topMenu.element[0].getBoundingClientRect();
                affix.register['topMenu'] = topMenu;
            }

            var sidebar = false;
            if (ERUI.sidebar && ERUI.sidebar.length > 0) {
                sidebar = {};
                sidebar.element = ERUI.sidebar;
                sidebar.position = sidebar.element[0].getBoundingClientRect();
                sidebar.fix = {};
                sidebar.attached = false;
                sidebar.fix.element = sidebar.element.find('#sidebar_inner,#easy_grid_sidebar_inner').not('.edit');
                if (sidebar.fix.element && sidebar.fix.element.length > 0){
                    sidebar.fix.position = sidebar.fix.element[0].getBoundingClientRect();
                    sidebar.fix.parent ={};
                    sidebar.fix.parent.element = sidebar.fix.element.parent();
                    if (sidebar.fix.parent.element && sidebar.fix.parent.element.length > 0){
                        sidebar.fix.parent.position = sidebar.fix.parent.element[0].getBoundingClientRect();
                        sidebar.fix.width = sidebar.fix.element[0].clientWidth;
                        sidebar.fix.next = sidebar.fix.element.next();
                        if(reset){
                            sidebar.fix.element.css({
                                zIndex: 1,
                                position: 'relative',
                                willChange: 'transform',
                                width: sidebar.fix.width,
                                MsTransform: 'translate(0,0)',
                                WebkitTransform: 'translate(0,0)',
                                transform: 'translate(0,0)'
                            });
                        }
                        affix.enabled.sidebar = true;
                        sidebar.offset = 24;
                        affix.register['sidebar'] = sidebar;
                    }
                }

                var sideScrollEl = ERUI.sidebar.find('#sidebar_content, #easy_grid_sidebar_content').not('.edit');
                if(sideScrollEl && sideScrollEl.length > 0){
                    var footerEl = sideScrollEl.next('#sidebar_footer');
                    var footerHeight = footerEl.outerHeight();
                    var windowHeight = ERUI.window.outerHeight();

                    var sideScrollElOffs = sideScrollEl[0].offsetTop;
                    var sidebarOffsTop = ERUI.sidebar.offset().top;
                    ERUI.sidebarOffsTop = sidebarOffsTop;
                    ERUI.sideScrollElOffs = sideScrollElOffs;
                    var sideScrollElHight = windowHeight - sidebarOffsTop - sideScrollElOffs - 5;
                    ERUI.sideScrollElHight = sideScrollElHight;

                    sideScrollEl = sideScrollEl.children('.easy-scroller');
                    ERUI.sideScrollEl = sideScrollEl;
                    sideScrollEl.children().first().css({paddingBottom: footerHeight});
                    sideScrollEl.css({
                        height: ERUI.sideScrollElHight,
                        overflow: 'hidden',
                        position: 'relative'
                    }).perfectScrollbar({
                        suppressScrollX: true,
                        includePadding: true,
                        wheelPropagation: true,
                        swipePropagation: true
                    }).scroll(function () {
                        if (sideScrollEl.scrollTop() > 0) {
                            sideScrollEl.parent().addClass('scrolled');
                        } else {
                            sideScrollEl.parent().removeClass('scrolled');
                        }
                    });

                    footerEl.css({
                        position: 'absolute',
                        left: 0,
                        right: 0,
                        bottom: 0
                    })
                }

            }

            var tableScrolls = false;
            if (ERUI.tableScrolls && ERUI.tableScrolls.length > 0 ) {
                tableScrolls = {};
                tableScrolls.wrappers = {};
                tableScrolls.xbars = {};
                tableScrolls.wrappers.element = ERUI.tableScrolls;
                tableScrolls.wrappers.position = new Array();
                tableScrolls.xbars.element = new Array();
                tableScrolls.xbars.position = new Array();
                tableScrolls.xbars.element = tableScrolls.wrappers.element.children(".ps-scrollbar-x-rail");
                tableScrolls.wrappers.element.each(function(index){
                  tableScrolls.wrappers.position[index] = tableScrolls.wrappers.element[index].getBoundingClientRect();
                  tableScrolls.xbars.position[index] = tableScrolls.xbars.element[index].getBoundingClientRect();
                  });
                if(reset) {
                    tableScrolls.xbars.element.css({
                        willChange: 'transform',
                        MsTransform: 'translate(0,0)',
                        WebkitTransform: 'translate(0,0)',
                        transform: 'translate(0,0)'
                    });
                    affix.register['tableScrolls'] = tableScrolls;
                }
            }

            var tableHeads = false;
            if (ERUI.tableHeads && ERUI.tableHeads.length > 0 ) {
                tableHeads = {};
                tableHeads.element = ERUI.tableHeads;
                tableHeads.parent = {};
                tableHeads.fake = {};
                tableHeads.position = new Array();
                tableHeads.parent.element = new Array();
                tableHeads.parent.position = new Array();
                tableHeads.fake.elements = new Array();
                tableHeads.element.each(function(index){
                    if(tableHeads.element[index].parentNode === null) {
                        return;
                    }
                    tableHeads.parent.element[index] = tableHeads.element[index].parentNode;
                    //tableHeads.fake.element[index] = tableHeads.element[index].cloneNode(true);
                    //tableHeads.parent.element[index].appendChild(tableHeads.fake.element[index]);
                    tableHeads.position[index] = tableHeads.element[index].getBoundingClientRect();
                    tableHeads.parent.position[index] = tableHeads.parent.element[index].getBoundingClientRect();
                    tableHeads.fake.elements[index] = $(this).find('.affix-cell-wrap');
                    //tableHeads.parent.element[index].style.marginBottom = (1-Math.floor(tableHeads.position[index].height)) + 'px';
                    if(reset) {
                        tableHeads.fake.elements[index].each(function(){
                            this.style.willChange = 'transform';
                            this.style.MsTransform = 'translate(0,0)';
                            this.style.WebkitTransform = 'translate(0,0)';
                            this.style.transform = 'translate(0,0)';
                        });
                    }
                });
                //tableHeads.fake.elements = $(tableHeads.fake.elements);
                affix.register['tableHeads'] = tableHeads;
            }

            var formActions = false;
            if (ERUI.formActions && ERUI.formActions.length > 0 ) {
                formActions = {};
                formActions.element = ERUI.formActions;
                formActions.forms = {};
                formActions.position = new Array();
                formActions.height = new Array();
                formActions.forms.height = new Array();
                formActions.forms.position = new Array();
                formActions.forms.element = formActions.element.closest('form');
                formActions.element.each(function (index) {
                    formActions.forms.position[index] = formActions.forms.element[index].getBoundingClientRect();
                    formActions.position[index] = this.getBoundingClientRect();
                    formActions.height[index] = this.offsetHeight;
                    formActions.forms.height[index] = formActions.forms.element[index].offsetHeight;
                    $(formActions.forms.element[index]).css({
                        position: "relative",
                        paddingBottom: 24 + formActions.height[index]  + 'px'
                    });
                });
                if(reset) {
                    formActions.element.css({
                        willChange: 'transform,left,right',
                        positon: 'absolute',
                        left: '0',
                        right: '0'
                        //MsTransform: 'translate(0,0)',
                        //WebkitTransform: 'translate(0,0)',
                        //transform: 'translate(0,0)'
                    });
                }
                  affix.register['formActions'] = formActions;
            }
        }
    },
    read: function() {
        var sidebar = affix.register['sidebar'];
        if (sidebar && sidebar.fix.element) {
            sidebar.position = sidebar.element[0].getBoundingClientRect();
            sidebar.fix.position = sidebar.fix.element[0].getBoundingClientRect();
            sidebar.fix.parent.position = sidebar.fix.parent.element[0].getBoundingClientRect();
        }else{
            affix.enabled.sidebar = false;
        }

        var tableScrolls = affix.register['tableScrolls'];
        if (tableScrolls && tableScrolls.wrappers.element ) {
            tableScrolls.wrappers.element.each(function (index) {
                tableScrolls.wrappers.position[index] = tableScrolls.wrappers.element[index].getBoundingClientRect();
            });
        }
        var tableHeads = affix.register['tableHeads'];
        if (tableHeads  && tableHeads.element ) {
            tableHeads.element.each(function (index) {
                if(tableHeads.parent.element[index] === undefined)
                    return;
                tableHeads.position[index] = tableHeads.element[index].getBoundingClientRect();
                tableHeads.parent.position[index] = tableHeads.parent.element[index].getBoundingClientRect();
            });
        }
        var formActions = affix.register['formActions'];
        if (formActions) {
            formActions.element.each(function (index) {
                formActions.forms.position[index] = formActions.forms.element[index].getBoundingClientRect();
                formActions.position[index] = formActions.element[index].getBoundingClientRect();
            });
        }
    },
    tableScrolls: function() {
        var tableScrolls = affix.register['tableScrolls'];
        if (tableScrolls) {
            var scroller = affix.register['window'];
            tableScrolls.xbars.element.each(function(index){
                var wrapperPosition = tableScrolls.wrappers.position[index];
                var formBottomDistance = -1 * (scroller.height + 1 - wrapperPosition.top - wrapperPosition.height);
                if (formBottomDistance > 0) {
                  this.style.MsTransform = 'translate(0,'+(-formBottomDistance)+'px)';
                  this.style.WebkitTransform = 'translate(0,'+(-formBottomDistance)+'px)';
                  this.style.transform = 'translate(0,'+(-formBottomDistance)+'px)';
                } else {
                  this.style.MsTransform = 'translate(0,0)';
                  this.style.WebkitTransform = 'translate(0,0)';
                  this.style.transform = 'translate(0,0)';
                }
            })
        }
    },
    tableHeads: function() {
        var tableHeads = affix.register['tableHeads'];
        if (tableHeads) {
            var menuPosition = affix.register['topMenu'].position;
            if (menuPosition){
                mh = menuPosition.height;
            }else{
                mh = affix.register['main'].offsetTop;
            }
            tableHeads.element.each(function(index){
                var wrapperPosition = tableHeads.parent.position[index];
                var formTopDistance = mh - wrapperPosition.top +     1;
                if (wrapperPosition.top < menuPosition.height && wrapperPosition.top + wrapperPosition.height - 2*tableHeads.position[index].height > menuPosition.height) {
                    tableHeads.fake.elements[index].each(function(){
                        this.style.MsTransform = 'translate(0,'+(formTopDistance)+'px)';
                        this.style.WebkitTransform = 'translate(0,'+(formTopDistance)+'px)';
                        this.style.transform = 'translate(0,'+(formTopDistance)+'px)';
                        //this.style.opacity = '1';
                    });
                } else {
                    tableHeads.fake.elements[index].each(function(){
                        this.style.MsTransform = 'translate(0,0)';
                        this.style.WebkitTransform = 'translate(0,0)';
                        this.style.transform = 'translate(0,0)';
                        //this.style.opacity = '0';
                    });
                }
            })
        }
    },
    formActions: function(){
        var formActions = affix.register['formActions'];
        if (formActions){
            var topMenu = affix.register['topMenu'];
            var scroller = affix.register['window'];
            formActions.element.each(function(index){
              var formPosition = formActions.forms.position[index];
              var position= formActions.position[index]
              var formBottomDistance = -1*(scroller.height - formPosition.top - formActions.forms.height[index]);
              if (formBottomDistance > 0){
                if(formPosition.top < scroller.height - position.height + 20){
                  //this.style.MsTransform = 'translate(0,'+(-formBottomDistance)+'px)';
                  //this.style.WebkitTransform = 'translate(0,'+(-formBottomDistance)+'px)';
                  //this.style.transform = 'translate(0,'+(-formBottomDistance)+'px)';
                  this.style.position = 'fixed';
                  this.style.left = 24 + formPosition.left + 'px';
                  this.style.width = formPosition.width - 24 + 'px';
                  this.style.top = 'auto';
                  this.style.bottom = '0px';
                  this.style.marginBottom = '0';
                }else{
                  this.style.position = 'absolute';
                  this.style.top = '-25px';
                  this.style.left = '0';
                  this.style.right = '0';
                  this.style.width = 'auto';
                  this.style.bottom = 'auto';
                }
              }else{
                //this.style.MsTransform = 'translate(0,0)';
                //this.style.WebkitTransform = 'translate(0,0)';
                //this.style.transform = 'translate(0,0)';
                this.style.position = 'absolute';
                this.style.left = '0';
                this.style.right = '0';
                this.style.top = 'auto';
                this.style.width = 'auto';
                this.style.bottom = 'inherit';
              }
            });
        }
    },
    sidebar: function(){
        if (affix.enabled.sidebar){
            var topMenu = affix.register['topMenu'];
            var sidebar = affix.register['sidebar'];
            var position = sidebar.position.top - topMenu.position.height - sidebar.offset;
            if (position < 0) {
                if (!sidebar.attached) {
                    ERUI.document.trigger( "erui_affix_sidebar_attached" );
                    sidebar.attached = true;
                    sidebar.fix.element.css({
                        //MsTransform: 'translate(0,'+(-position)+'px)',
                        //WebkitTransform: 'translate(0,'+(-position)+'px)',
                        //transform: 'translate(0,'+(-position)+'px)'
                        position: 'fixed',
                        top: topMenu.position.height + sidebar.offset + 'px'
                    })
                }
            }else{
                if (sidebar.attached) {
                    ERUI.document.trigger( "erui_affix_sidebar_detached" );
                    sidebar.attached = false;
                    sidebar.fix.element.css({
                        //MsTransform: 'translate(0,0)',
                        //WebkitTransform: 'translate(0,0)',
                        //transform: 'translate(0,0)'
                        position: 'relative',
                        top: 'auto'
                    })
                }
            }

            var sideOffs = sidebar.fix.position.top;
            var sideScrollElOffs = ERUI.sideScrollElOffs;
            var windowHeight = ERUI.window.outerHeight();

            ERUI.sideScrollEl.css({
                height:  windowHeight - sideOffs - sideScrollElOffs - 5
            });

            //if (!sidebar.attached){
            //
            //    ERUI.sideScrollEl.css({
            //        height:  windowHeight - sidebar.fix.position - 5
            //    });
            //}else{
            //    ERUI.sideScrollEl.css({
            //        height:  windowHeight - sidebar.fix.position - 5
            //    });
            //}

        }
    }
};

window.onScroll = function (evt) {
    ERUI.scrollTopLast = ERUI.scrollTop;
    ERUI.scrollTop = window.scrollY;
    affix.read();
    requestFrame(function(){
        //do stuff
        affix.tableScrolls();
        affix.tableHeads();
        affix.formActions();
        affix.sidebar();
        if(ERUI.scrollTop){
            ERUI.backToTop.css({opacity: '1'});
        }else{
            ERUI.backToTop.css({opacity: '0'});
        }
    });
};

// $(window).resize(function () {
//     requestFrame(function() {
//         $('#easy_page_tabs').tabScrollButtons();
//     });
// });