Dir.glob(File.dirname(__FILE__) + '/extra/easy_project_com/easy_patch/**/*.rb').each {|file| require_dependency file }

EasyExtensions::EasyProjectSettings.app_name = 'Easy Project'
EasyExtensions::EasyProjectSettings.app_link = 'www.easyproject.com'
EasyExtensions::EasyProjectSettings.app_email = 'support@easyproject.com'
EasyExtensions::EasyProjectSettings.disabled_features[:modules] += ['gantt', 'calendar']
EasyExtensions::EasyProjectSettings.disabled_features[:permissions]['gantt'] = :all

Rails.application.config.i18n.load_path += Dir.glob(File.dirname(__FILE__) + '/config/locales/**/*.yml').sort

# if defined?(EasyExtensions::EasyProjectSettings.default_pdf_logo) && defined?(EasyExtensions::EasyProjectSettings.default_pdf_logo_image)
#   EasyExtensions::EasyProjectSettings.default_pdf_logo = File.join(EasyExtensions::EASYPROJECT_EASY_PLUGINS_DIR, 'easy_project_com', 'assets', 'images', 'default_pdf_logo.png')
#   EasyExtensions::EasyProjectSettings.default_pdf_logo_image = '/plugin_assets/easy_project_com/images/default_pdf_logo.png'
# end

if EasyExtensions::EasyProjectSettings.enable_copying_files_on_restart
  begin
    FileUtils.cp("#{EasyExtensions::PATH_TO_EASYPROJECT_ROOT}/easy_plugins/easy_project_com/extra/easy_project_com/to_copy/404.html", "#{Rails.root}/public/404.html")
    FileUtils.cp("#{EasyExtensions::PATH_TO_EASYPROJECT_ROOT}/easy_plugins/easy_project_com/extra/easy_project_com/to_copy/500.html", "#{Rails.root}/public/500.html")
    FileUtils.cp("#{EasyExtensions::PATH_TO_EASYPROJECT_ROOT}/easy_plugins/easy_project_com/extra/easy_project_com/to_copy/502.html", "#{Rails.root}/public/502.html")
  rescue
  end
end

EasyExtensions::PatchManager.register_controller_patch 'ApplicationController', 'EasyInviteColleagues::ApplicationControllerPatch', if: Proc.new {Redmine::Plugin.installed?(:easy_invite_colleagues)}
EasyExtensions::PatchManager.register_controller_patch 'MyController', 'EasyInviteColleagues::MyControllerPatch', if: Proc.new {Redmine::Plugin.installed?(:easy_invite_colleagues)}

require_relative 'extra/easy_project_com/sso_easyproject_com'
Rails.application.config.middleware.use OmniAuth::Builder do
  provider :sso, '2m8CnDJLFrupTqSjx2fga9ZoWa47DBtb', 'dH5HhF5idLMmBHsYgiivGn7KNEi84eqB'
end

ActiveSupport.on_load(:easyproject, yield: true) do
  require 'easy_project_com/hooks'
  require 'easy_project_com/menus'

  EasyExtensions::EasyProjectSettings.iconset = Pathname.new(EasyExtensions::RELATIVE_EASYPROJECT_EASY_PLUGINS_PATH).join('easy_project_com/assets/stylesheets/scss/_variables_icons.scss')

  Redmine::Plugin.bundled_plugin_ids = {
      basic: [
                 :easy_wbs,
                 :easy_gantt,
                 :easy_gantt_pro,
                 :easy_earned_values,
                 :easy_baseline,
                 :easy_checklist,
                 :easy_calendar,
                 :easy_agile_board,
                 :easy_timesheets,
                 :easy_entities_sequences,
                 :easy_theme_designer,
                 :easy_project_attachments,
                 :easy_computed_custom_fields,
                 :easy_printable_templates,
                 :easy_quick_project_planner,
                 :easy_instant_messages,
                 :easy_to_do_list,
                 :easy_buttons
             ],
      resource: [
                 :easy_resource_dashboard,
                 :easy_gantt_resources,
                 :easy_attendances
             ],
      finance: [
                 :easy_money,
                 :easy_budgetsheet,
                 :easy_calculation,
                 :easy_cash_desks,
                 :easy_personal_finances
             ],
      customers: [
                 :easy_crm,
                 :easy_contacts,
                 :easy_price_books
             ],
      helpdesk: [
                 :easy_helpdesk,
                 :easy_alerts
             ],
      extra: [
                 :redmine_dmsf,
                 :easy_invoicing,
                 :easy_knowledge,
                 :redmine_test_cases
             ]
  }

end

Rails.application.configure do
  # Rails.application.config.assets.paths = Rails.application.config.assets.paths.select{|i| i.match('easy_extensions.*(stylesheets|fonts)')}

  assets_dir = Redmine::Plugin.find(:easy_project_com).assets_directory
  config.assets.paths << File.join(assets_dir, 'easy_fonts')
  config.assets.paths << File.join(assets_dir)
  config.assets.precompile.concat Dir.glob(File.join(assets_dir, 'easy_fonts', '*'))
  precompile_css = %w(easy_project_print.css easy_project_theme.css)
  config.assets.precompile += %w( easy_project_extensions.css easy_project_extensions.js)
  config.assets.precompile.concat precompile_css.collect{|n| File.join(assets_dir, 'stylesheets', n) }
  #config.assets.precompile.concat precompile_js.collect{|n| File.join(assets_dir, 'javascripts', n) }

end
