class EasyPrintableTemplateQuery < EasyQuery

  def available_filters
    return @available_filters unless @available_filters.blank?
    group = l("label_filter_group_#{self.class.name.underscore}")
    @available_filters = {
      'project_id' => { :type => :list, :time_column => true, :order => 1, :values => self.all_projects_values, :group => group},
      'author_id' => {:type => :list, :order => 2, :values => User.active.non_system_flag.sorted.collect{|t| [t.name, t.id]}, :name => l(:'activerecord.attributes.easy_printable_template.author'), :group => group},
      'name' => {:type => :string, :order => 4, :name => l(:'activerecord.attributes.easy_printable_template.name'), :group => group},
      'private' => {:type => :boolean, :order => 5, :name => l(:'activerecord.attributes.easy_printable_template.private'), :group => group},
      'pages_orientation' => {:type => :list, :order => 6, :values => [[EasyPrintableTemplate.translate_pages_orientation(EasyPrintableTemplate::PAGES_ORIENTATION_PORTRAIT), EasyPrintableTemplate::PAGES_ORIENTATION_PORTRAIT], [EasyPrintableTemplate.translate_pages_orientation(EasyPrintableTemplate::PAGES_ORIENTATION_LANDSCAPE), EasyPrintableTemplate::PAGES_ORIENTATION_LANDSCAPE]], :name => l(:'activerecord.attributes.easy_printable_template.pages_orientation'), :group => group},
      'pages_size' => {:type => :list, :order => 7, :values => [['A3', 'a3'], ['A4', 'a4']], :name => l(:'activerecord.attributes.easy_printable_template.pages_size'), :group => group},
    }

    return @available_filters
  end

  def available_columns
    unless @available_columns_added
      group = l("label_filter_group_#{self.class.name.underscore}")
      group_user = l('label_user_plural')
      @available_columns = [
        EasyQueryColumn.new(:project, :sortable => "#{Project.table_name}.name", :group => group),
        EasyQueryColumn.new(:author, :sortable => lambda{User.fields_for_order_statement}, :caption => :'activerecord.attributes.easy_printable_template.author', :group => group_user),
        EasyQueryColumn.new(:name, :sortable => "#{EasyPrintableTemplate.table_name}.name", :caption => :'activerecord.attributes.easy_printable_template.name', :group => group),
        EasyQueryColumn.new(:description, :caption => :'activerecord.attributes.easy_printable_template.description', :group => group),
        EasyQueryColumn.new(:category_caption, :groupable => "#{EasyPrintableTemplate.table_name}.category", :caption => :'activerecord.attributes.easy_printable_template.category', :group => group),
        EasyQueryColumn.new(:private, :sortable => "#{EasyPrintableTemplate.table_name}.private", :caption => :'activerecord.attributes.easy_printable_template.private', :group => group),
        EasyQueryColumn.new(:pages_orientation, :sortable => "#{EasyPrintableTemplate.table_name}.pages_orientation", :caption => :'activerecord.attributes.easy_printable_template.pages_orientation', :group => group),
        EasyQueryColumn.new(:pages_size, :sortable => "#{EasyPrintableTemplate.table_name}.pages_size", :caption => :'activerecord.attributes.easy_printable_template.pages_size', :group => group),
      ]

      @available_columns_added = true
    end
    @available_columns
  end

  def entity
    EasyPrintableTemplate
  end

  def entity_easy_query_path(options)
    easy_printable_templates_path options
  end

  def default_find_include
    [:project, :author]
  end

  def searchable_columns
    ["#{Project.table_name}.name", "#{User.table_name}.firstname", "#{User.table_name}.lastname", "#{EasyPrintableTemplate.table_name}.name"]
  end

end
