EasyExtensions.register_additional_installer_tasks('easyproject:easy_printable_templates:generate_pdfkit_initializer')

Dir[File.dirname(__FILE__) + '/lib/easy_printable_templates/easy_patch/**/*.rb'].each {|file| require_dependency file }

EasyExtensions::PatchManager.register_easy_page_controller 'EasyPrintableTemplatesController'

ActionDispatch::Reloader.to_prepare do

  require 'easy_printable_templates/hooks'
  require 'easy_printable_templates/menus'

  EasyQuery.map do |query|
    query.register EasyPrintableTemplateQuery
  end

end

ActiveSupport.on_load(:easyproject, yield: true) do
  require 'easy_printable_templates/proposer'

  Redmine::MenuManager.map :admin_menu do |menu|
    menu.push(:easy_printable_templates_plugin_name, { controller: 'easy_printable_templates', action: 'index', format: nil }, {
        :parent => :documents,
        :if => Proc.new { User.current.admin? },
        :html => { :class => 'icon icon-print', :title => :title_other_formats_links_print },
        :caption => :easy_printable_templates_plugin_name,
        :after => :easy_pdf_themes
      })
  end
end
