require File.expand_path('../../spec_helper', __FILE__)

describe Journal do

  describe 'notified users of issue journal' do
    let!(:project) { FactoryGirl.create(:project, enabled_module_names: ['issue_tracking']) }
    let!(:users) { FactoryGirl.create_list(:user, 2, mail_notification: 'all') }
    let!(:group) { FactoryGirl.create(:group, users: users) }
    let!(:parent_issue) { FactoryGirl.create(:issue, project: project) }
    let!(:issue1) { FactoryGirl.create(:issue, project: project, parent: parent_issue, assigned_to: nil) }
    let!(:issue2) { FactoryGirl.create(:issue, project: project, parent: parent_issue, assigned_to: group) }
    let(:journal) { FactoryGirl.create(:journal, journalized_id: parent_issue.id, journalized_type: 'Issue', notify_children: true) }

    it 'returns array of users including users from child issues' do
      expect(journal.notified_users.size).to eq(2)
    end
  end

end
