# encoding: UTF-8
require File.expand_path('../../spec_helper', __FILE__)

RSpec.describe EasyTranslation, :type => :model do

  let(:issue_status) { FactoryGirl.create(:issue_status, name: 'New') }

  before(:each) { I18n.locale = :cs }

  it 'creates a translation for given entity' do

    easy_translation = EasyTranslation.set_translation(
      issue_status,
      'name',
      'Nový / aktivovat',
      :cs
    )
    easy_translation.save

    expect( IssueStatus.find(issue_status.id).name ).to eq( easy_translation.value )
  end

  it '.set_translation invalidates cache when translation is changed' do
    easy_translation = EasyTranslation.set_translation(
      issue_status,
      'name',
      'Nový / aktivovat',
      :cs
    )
    easy_translation.save

    expect( IssueStatus.find(issue_status.id).name ).to eq( easy_translation.value )

    changed_translation = 'Nový'
    EasyTranslation.set_translation(
      issue_status,
      'name',
      changed_translation,
      :cs
    ).save

    expect( IssueStatus.find(issue_status.id).name ).to eq( changed_translation )
  end

end
