require File.expand_path('../../spec_helper', __FILE__)

describe TemplatesController, :logged => :admin do
  let(:template) { FactoryGirl.create(:project, :members => [User.current], :easy_is_easy_template => true) }

  it 'wrong params' do
    post :make_project_from_template, :id => template, :template => {:project => [{:id => 123, :identifier => 'xxx', :custom_field_values => {'1' => 'x'}}]}
    expect(response).not_to have_http_status(500)
  end

  it 'invalid template' do
    template.name = ''
    template.save(:validate => false)
    post :make_project_from_template, :id => template, :template => {:start_date => '2017-03-16', :update_dates => '1', :change_issues_author => '', :assign_entity => {:type => '', :id => ''}}
    expect(response).not_to have_http_status(500)
  end

  it 'without custom_field_values' do
    post :make_project_from_template, :id => template, :template => {:project => [{:id => 123, :identifier => 'xxx'}]}
    expect(response).not_to have_http_status(500)
  end
end
