require File.expand_path('../../spec_helper', __FILE__)

describe NewsController, :logged => :admin do
  let(:project) { FactoryGirl.create(:project, :members => [User.current], :enabled_module_names => ['news']) }

  render_views

  it 'render news' do
    ['HTML', 'textile', 'markdown'].each do |f|
      with_settings({'text_formatting' => f}) do
        get :index, :project_id => project.id
        expect(response).to be_success
      end
    end
  end
end
