require File.expand_path('../../spec_helper', __FILE__)

describe IssueRelationsController, :logged => :admin do

  let(:project) { FactoryGirl.create(:project, number_of_issues: 0) }
  let(:issue1) { FactoryGirl.create(:issue, :project => project) }
  let(:issue2) { FactoryGirl.create(:issue, :project => project) }

  render_views

  def create_relation
    relation = IssueRelation.new
    relation.issue_from = issue1
    relation.issue_to = issue2
    relation.relation_type = 'relates'
    relation.save!
    relation
  end

  it 'destroy html' do
    delete :destroy, :id => create_relation.id, :issue_id => issue1.id
    expect(response).to have_http_status(302)
  end

  it 'destroy js' do
    delete :destroy, :id => create_relation.id, :issue_id => issue1.id, :format => 'js'
    expect(response).to be_success
  end

  it 'destroy json' do
    delete :destroy, :id => create_relation.id, :issue_id => issue1.id, :format => 'json'
    expect(response).to be_success
  end

end