require File.expand_path('../../spec_helper', __FILE__)

describe EasyUserWorkingTimeCalendarsController, :logged => :admin do
  let(:wc){ FactoryGirl.create(:easy_user_time_calendar) }

  it 'valid exceptions' do
    post :mass_exceptions, :id => wc, :mass_exception => {:from => Date.today, :to => Date.today + 1, :working_hours => 8, :back_url => '/'}
    expect(response).not_to have_http_status(500)
  end

  it 'exceptions without from/to/back_url/params' do
    post :mass_exceptions, :id => wc, :mass_exception => {:to => Date.today + 1, :working_hours => 8, :back_url => '/'}
    expect(response).not_to have_http_status(500)

    post :mass_exceptions, :id => wc, :mass_exception => {:from => Date.today, :working_hours => 8, :back_url => '/'}
    expect(response).not_to have_http_status(500)

    post :mass_exceptions, :id => wc, :mass_exception => {:from => Date.today, :to => Date.today + 1, :working_hours => 8}
    expect(response).not_to have_http_status(500)

    post :mass_exceptions, :id => wc
    expect(response).not_to have_http_status(500)
  end
end