require File.expand_path('../../spec_helper', __FILE__)

describe Admin::EasySettingsController, :type => :controller, :logged => :admin do
  render_views

  it 'show' do
    with_easy_settings('dummy_setting' => 'show_value') do
      get :show, :format => 'json', :id => EasySetting.find_by(:name => 'dummy_setting').id
      expect(response).to be_success
      expect(json.values_at(:value, :name)).to eq(['show_value', 'dummy_setting'])
    end
  end

  it 'update' do
    with_easy_settings('dummy_setting' => 'value') do
      put :update, :format => 'json', :id => EasySetting.find_by(:name => 'dummy_setting').id, :easy_setting => {:value => 'new_value'}
      expect(response).to be_success
      expect(EasySetting.find_by(:name => 'dummy_setting').value).to eq('new_value')
    end
  end

  it 'create' do
    EasySetting.where(:name => 'dummy_setting').destroy_all
    post :create, :format => 'json', :easy_setting => {:name => 'dummy_setting', :value => 'my_value'}
    expect(response).to be_success
    expect(EasySetting.find_by(:name => 'dummy_setting').value).to eq('my_value')
  end

end
