require File.expand_path('../../spec_helper', __FILE__)

describe ContextMenusController do
  context 'when issue context menu' do
    render_views

    let(:issue) { FactoryGirl.create(:issue) }
    let(:role) do
      role = FactoryGirl.create(:role)
      role.remove_permission!(:edit_issues, :add_issues)
      role
    end
    let(:member) { FactoryGirl.create(:member, :without_roles, :project => issue.project, :user => User.current) }
    let!(:member_role) { FactoryGirl.create(:member_role, :member => member, :role => role) }

    before(:each) { get :issues, :ids => [issue.id] }

    context 'when user cannot edit issue', :logged => true do
      it 'does not contain link to update Tracker' do
        expect(response.body).not_to include('tracker_id')
      end
    end

    context 'when user can edit issue', :logged => :admin do
      it 'contains link to update Tracker' do
        expect(response.body).to include('tracker_id')
      end
    end
  end

  context 'time entry context menu', :logged => :admin do
    render_views

    let!(:time_entry) { FactoryGirl.create(:time_entry) }

    it 'removed time entry' do
      time_entry_id = time_entry.id
      time_entry.destroy
      get :time_entries, :ids => [time_entry_id]
      expect(response).to have_http_status(404)
    end

    it 'show menu' do
      get :time_entries, :ids => [time_entry.id]
      expect(response).to be_success
    end
  end
end
